#!/usr/bin/env python

import os
import sys
import time
import shutil
from commons.core.checker.RepetException import RepetException
from commons.core.sql.TableJobAdaptator import TableJobAdaptator
from commons.core.sql.DbMySql import DbMySql
from commons.core.sql.DbSQLite import DbSQLite
from commons.core.sql.Job import Job

try:
	newDir = None
	print os.uname()
	beginTime = time.time()
	print 'beginTime=%f' % beginTime
	print "work in dir '/home/user/workspace/repet_pipe/commons/core/launcher/test/dummyScratch'"
	sys.stdout.flush()
	if not os.path.exists("/home/user/workspace/repet_pipe/commons/core/launcher/test/dummyScratch"):
		raise IOError("ERROR: temporary directory '/home/user/workspace/repet_pipe/commons/core/launcher/test/dummyScratch' doesn't exist")
	
	fileSize = 0
	if not os.path.exists("groupid"):
		fileSize = 0.500000
	freeGigaNeededInTmpDir = float(1 + fileSize)
	freeSpace = os.statvfs("/home/user/workspace/repet_pipe/commons/core/launcher/test/dummyScratch")
	if ((freeSpace.f_bavail * freeSpace.f_frsize) / 1073741824.0 < freeGigaNeededInTmpDir):
		raise RepetException("ERROR: less than %.2fG of input file in '/home/user/workspace/repet_pipe/commons/core/launcher/test/dummyScratch'" % freeGigaNeededInTmpDir)
	
	os.chdir("/home/user/workspace/repet_pipe/commons/core/launcher/test/dummyScratch")
	if not os.path.exists("groupid"):
		try:
			os.mkdir("groupid")
		except OSError, e :
			if e.args[0] != 17:
				raise RepetException("ERROR: can't create 'groupid'")
		os.chdir("groupid")
		os.system("touch bank.fa")
	else:
		os.chdir("groupid")
	
	newDir = "groupid_job1_20110505-105353"
	if os.path.exists(newDir):
		shutil.rmtree(newDir)
	os.mkdir(newDir)
	os.chdir(newDir)
	
	queue = "main.q"
	iJob = Job("jobs", jobname = "job1", groupid = "groupid", queue = queue, node = os.getenv("HOSTNAME"))
	iDb = DbSQLite("/home/user/workspace/repet_pipe/commons/core/launcher/test/jobs")
	iTJA = TableJobAdaptator(iDb, "jobs")
	print "current status: %s" % iTJA.getJobStatus(iJob)
	iTJA.changeJobStatus(iJob, "running")
	print "updated status: %s" % iTJA.getJobStatus(iJob)
	iDb.close()
	
	log = os.system("touch dummyFile1")
	if log != 0:
		raise RepetException("ERROR: job returned %i" % log)
	else:
		print "job finished successfully"
	shutil.move("dummyFile1", "/home/user/workspace/repet_pipe/commons/core/launcher/test")
	
	os.chdir("..")
	shutil.rmtree(newDir)
	
	iDb = DbSQLite("/home/user/workspace/repet_pipe/commons/core/launcher/test/jobs")
	iTJA = TableJobAdaptator(iDb, "jobs")
	print "current status: %s" % iTJA.getJobStatus(iJob)
	iTJA.changeJobStatus(iJob, "finished")
	print "updated status: %s" % iTJA.getJobStatus(iJob)
	iDb.close()
	
	endTime = time.time()
	print 'endTime=%f' % endTime
	print 'executionTime=%f' % (endTime - beginTime)
	print os.uname()

except IOError, e :
	print e
	queue = "main.q"
	iJob = Job("jobs", jobname = "job1", groupid = "groupid", queue = queue, node = os.getenv("HOSTNAME"))
	iDb = DbSQLite("/home/user/workspace/repet_pipe/commons/core/launcher/test/jobs")
	iTJA = TableJobAdaptator(iDb, "jobs")
	print "current status: %s" % iTJA.getJobStatus(iJob)
	iTJA.changeJobStatus(iJob, "error")
	print "updated status: %s" % iTJA.getJobStatus(iJob)
	iDb.close()
	sys.exit(1)

except Exception, e :
	print "tmpDir is : /home/user/workspace/repet_pipe/commons/core/launcher/test/dummyScratch"
	print "cDir is : /home/user/workspace/repet_pipe/commons/core/launcher/test/"
	print e
	if newDir != None and os.path.exists("../%s" % newDir) and not os.path.exists("/home/user/workspace/repet_pipe/commons/core/launcher/test//%s" % newDir):
		os.chdir("..")
		shutil.move(newDir, "/home/user/workspace/repet_pipe/commons/core/launcher/test//%s" % newDir)
	queue = "main.q"
	iJob = Job("jobs", jobname = "job1", groupid = "groupid", queue = queue, node = os.getenv("HOSTNAME"))
	iDb = DbSQLite("/home/user/workspace/repet_pipe/commons/core/launcher/test/jobs")
	iTJA = TableJobAdaptator(iDb, "jobs")
	print "current status: %s" % iTJA.getJobStatus(iJob)
	iTJA.changeJobStatus(iJob, "error")
	print "updated status: %s" % iTJA.getJobStatus(iJob)
	iDb.close()
	sys.exit(1)
