import unittest
import os
from commons.core.parsing.MapParser import MapParser

class Test_MapParser(unittest.TestCase):

    
    def setUp(self):
        self.inputMapFileName = "testMapParser.map"
        self._writeInputMapFile()
        
    def tearDown(self):
        if os.path.exists(self.inputMapFileName):
            os.remove(self.inputMapFileName)
    
    def test_Parser(self):
        parser = MapParser(self.inputMapFileName)
        
        cpt = 0
        for transcript in parser.getIterator():
            cpt += 1
            if cpt == 1:
                self.assertEqual(transcript.getChromosome(), "dmel_chr4")
                self.assertEqual(transcript.getName(), "aagatgcgtaacggccatac_17")
                self.assertEqual(transcript.getStart(), 4380)
                self.assertEqual(transcript.getEnd(), 4400)
                self.assertEqual(transcript.getDirection(), 1)
                self.assertEqual(transcript.getSize(), 21)
            elif cpt == 10:
                self.assertEqual(transcript.getChromosome(), "dmel_chr4")
                self.assertEqual(transcript.getName(), "aacggccatacattggtttg_12")
                self.assertEqual(transcript.getStart(), 4389)
                self.assertEqual(transcript.getEnd(), 4409)
                self.assertEqual(transcript.getDirection(), 1)
                self.assertEqual(transcript.getSize(), 21)
                
                
    def _writeInputMapFile(self):
        inputFile = open(self.inputMapFileName,'w')
        inputFile.write("aagatgcgtaacggccatac_17\tdmel_chr4\t4380\t4400\n")
        inputFile.write("agatgcgtaacggccataca_16\tdmel_chr4\t4381\t4401\n")
        inputFile.write("gatgcgtaacggccatacat_16\tdmel_chr4\t4382\t4402\n")
        inputFile.write("atgcgtaacggccatacatt_15\tdmel_chr4\t4383\t4403\n")
        inputFile.write("tgcgtaacggccatacattg_15\tdmel_chr4\t4384\t4404\n")
        inputFile.write("gcgtaacggccatacattgg_15\tdmel_chr4\t4385\t4405\n")
        inputFile.write("cgtaacggccatacattggt_14\tdmel_chr4\t4386\t4406\n")
        inputFile.write("gtaacggccatacattggtt_14\tdmel_chr4\t4387\t4407\n")
        inputFile.write("taacggccatacattggttt_14\tdmel_chr4\t4388\t4408\n")
        inputFile.write("aacggccatacattggtttg_12\tdmel_chr4\t4389\t4409\n")
        inputFile.close()

if __name__ == '__main__':
        unittest.main()