import unittest
import struct
import os
from SMART.Java.Python.structure.Interval import Interval
from SMART.Java.Python.ncList.FindOverlapsWithOneInterval import FindOverlapsWithOneInterval
from SMART.Java.Python.ncList.NCListCursor import NCListCursor

class Test_FindOverlapsWithOneInterval(unittest.TestCase):

    def setUp(self):
        self._inputGff3FileName = 'sortedFile.gff3'
        self._writeGFF3File(self._inputGff3FileName)
        self._obsFileName = "overlap.gff3"
        self._iFOWOI = FindOverlapsWithOneInterval(0)
        self._iFOWOI.setFileName(self._inputGff3FileName, "gff3")
        self._iFOWOI._chromosome = "chr1"
        self._iFOWOI.prepareIntermediateFiles()
        self._iFOWOI.createNCList()
        self._ncList = self._iFOWOI._ncList
        self._iFOWOI.setOutputFileName(self._obsFileName)
        
    def tearDown(self):
        return
        self._iFOWOI.close()
        for file in (self._inputGff3FileName, self._obsFileName):
            if os.path.exists(file):
                os.remove(file)
        
    def test_binarySearch_first_element_overlap(self):
        self._iFOWOI.setInterval("chr1", 500, 850)
        obsReadPosition = self._iFOWOI.binarySearch(NCListCursor(None, self._ncList, 0, 0), 0, 6)
        expReadPosition = 0
        self._iFOWOI.dumpWriter()
        self._iFOWOI.close()
        self.assertEquals(expReadPosition, obsReadPosition._lIndex)
        
    def test_binarySearch_second_element_overlap(self):
        self._iFOWOI.setInterval("chr1", 500, 850)
        obsReadPosition = self._iFOWOI.binarySearch(NCListCursor(None, self._ncList, 2, 0), 2, 6)
        expReadPosition = 3
        self._iFOWOI.dumpWriter()
        self._iFOWOI.close()
        self.assertEquals(expReadPosition, obsReadPosition._lIndex)
        
    def test_binarySearch_empty_subList(self):
        self._iFOWOI.setInterval("chr1", 500, 850)
        obsReadPosition = self._iFOWOI.binarySearch(NCListCursor(None, self._ncList, 5, 0), 5, 5)
        expReadPosition = None
        self._iFOWOI.dumpWriter()
        self._iFOWOI.close()
        self.assertEquals(expReadPosition, obsReadPosition)
        
    def test_binarySearch_no_overlap_right(self):
        self._iFOWOI.setInterval("chr1", 1400, 1500)
        obsReadPosition = self._iFOWOI.binarySearch(NCListCursor(None, self._ncList, 0, 0), 0, 6)
        expReadPosition = None
        self._iFOWOI.dumpWriter()
        self._iFOWOI.close()
        self.assertEquals(expReadPosition, obsReadPosition)
        
    def test_binarySearch_no_overlap_left(self):
        self._iFOWOI.setInterval("chr1", 0, 45)       
        obsReadPosition = self._iFOWOI.binarySearch(NCListCursor(None, self._ncList, 2, 0), 2, 6)
        expReadPosition = None
        self._iFOWOI.dumpWriter()
        self._iFOWOI.close()
        self.assertEquals(expReadPosition, obsReadPosition)

    def _writeGFF3File(self, fileName):
        f = open(fileName, "w")
        f.write("chr1\ttest\ttest2.1\t9\t1000\t1001\t+\t.\tID=test2.1;Name=test2.1\n")
        f.write("chr1\ttest\ttest2.2\t50\t350\t301\t+\t.\tID=test2.2;Name=test2.2\n")
        f.write("chr1\ttest\ttest2.3\t100\t600\t501\t+\t.\tID=test2.3;Name=test2.3\n")
        f.write("chr1\ttest\ttest2.4\t200\t450\t251\t+\t.\tID=test2.4;Name=test2.4\n")
        f.write("chr1\ttest\ttest2.5\t700\t950\t251\t+\t.\tID=test2.5;Name=test2.5\n")
        f.write("chr1\ttest\ttest2.6\t800\t900\t101\t+\t.\tID=test2.6;Name=test2.6\n")
        f.write("chr1\ttest\ttest2.7\t1200\t1300\t101\t+\t.\tID=test2.7;Name=test2.7\n")
        f.close()
        
if __name__ == "__main__":
    unittest.main()
