import unittest
import os
from SMART.Java.Python.ncList.FindOverlapsWithSeveralIntervals import FindOverlapsWithSeveralIntervals

class Test_FindOverlapsWithSeveralIntervals(unittest.TestCase):

    def setUp(self):
        self._inputRefGff3FileName = 'sortedFile.gff3'
        self._writeGFF3File(self._inputRefGff3FileName)
        self._inputQueryGff3FileName = 'sorted_Query.gff3'
        self._writeQueryGff3File(self._inputQueryGff3FileName)
        self._outputGff3FileName = 'overlaps.gff3'
        self._iFOWSI = FindOverlapsWithSeveralIntervals(self._inputRefGff3FileName, self._inputQueryGff3FileName)
        self._iFOWSI.setOutputGff3FileName(self._outputGff3FileName)
        
    def tearDown(self):
        os.remove(self._inputRefGff3FileName)
        os.remove(self._inputQueryGff3FileName)
        os.remove(self._outputGff3FileName)
        self._iFOWSI.deletIntermediateFiles()
    
    def test_isOverlapping_true(self):
        queryGff3Addr = 116
        RefGff3Addr = 231
        obs = self._iFOWSI.isOverlapping(queryGff3Addr, RefGff3Addr)
        exp = 0
        self.assertEquals(exp, obs)
        
    def test_isOverlapping_false_left(self):
        queryGff3Addr = 116
        RefGff3Addr = 58
        obs = self._iFOWSI.isOverlapping(queryGff3Addr, RefGff3Addr)
        exp = -1
        self.assertEquals(exp, obs)
    
    def test_isOverlapping_false_right(self):
        queryGff3Addr = 116
        RefGff3Addr = 347
        obs = self._iFOWSI.isOverlapping(queryGff3Addr, RefGff3Addr)
        exp = 1
        self.assertEquals(exp, obs) 
           
    def test_getHisFirstChild(self):
        firstRefLAddr = 0
        obsFirstChildLAddr = self._iFOWSI.getHisFirstChild(firstRefLAddr)
        expFirstChildLAddr = 48
        self.assertEquals(expFirstChildLAddr, obsFirstChildLAddr) 
    
    def test_isLastElement_true(self):
        refLAddr = 96
        obsBool = self._iFOWSI.isLastElement(refLAddr)
        expBool = True
        self.assertEquals(expBool, obsBool)
    
    def test_isLastElement_false(self):
        refLAddr = 72
        obsBool = self._iFOWSI.isLastElement(refLAddr)
        expBool = False
        self.assertEquals(expBool, obsBool)  
        
    def test_isLastElement_highestLevel_true(self):
        refLAddr = 24
        obsBool = self._iFOWSI.isLastElement(refLAddr)
        expBool = True
        self.assertEquals(expBool, obsBool)
    
    def test_isLastElement_highestLevel_false(self):
        refLAddr = 0
        obsBool = self._iFOWSI.isLastElement(refLAddr)
        expBool = False
        self.assertEquals(expBool, obsBool)           

    def test_findOverlapIter(self):
        queryGff3Addr = 175
        firstRefLAddr = 0 
        obsFirstOverlapLAddr = self._iFOWSI.findOverlapIter(queryGff3Addr, firstRefLAddr)
        expFirstOverlapLAddr = 0
        self.assertEquals(expFirstOverlapLAddr, obsFirstOverlapLAddr)
        
    def test_not_findOverlapIter(self):
        queryGff3Addr = 295
        firstRefLAddr = 24 
        obsFirstOverlapLAddr = self._iFOWSI.findOverlapIter(queryGff3Addr, firstRefLAddr)
        expFirstOverlapLAddr = None
        self.assertEquals(expFirstOverlapLAddr, obsFirstOverlapLAddr)   
        
    def test_findOverlapIter_not_the_first_RefOverlap(self):
        queryGff3Addr = 235
        firstRefLAddr = 0 
        obsFirstOverlapLAddr = self._iFOWSI.findOverlapIter(queryGff3Addr, firstRefLAddr)
        expFirstOverlapLAddr = 24
        self.assertEquals(expFirstOverlapLAddr, obsFirstOverlapLAddr)  
        
    def test_changeToNewSubEndLAddr(self):
        firstChildLAddr = 48
        subEndLAddr = 48
        expSubEndLAddr = 120
        obsSubEndLAddr = self._iFOWSI.changeToNewSubEndLAddr(firstChildLAddr, subEndLAddr)
        self.assertEquals(expSubEndLAddr, obsSubEndLAddr) 
        
    def test_defineSubEndLaddr(self):
        parentLAddr = -1
        expSubEndLAddr = 48
        obsSubEndLAddr = self._iFOWSI.defineSubEndLaddr(parentLAddr)
        self.assertEquals(expSubEndLAddr, obsSubEndLAddr)
        
    def test_getNextRefIntervalInCaseNotOverLap(self):
        firstRefLAddr = 96
        expRefLAddr = 24
        obsRefLAddr = self._iFOWSI.getNextRefIntervalInCaseNotOverLap(firstRefLAddr)
        self.assertEquals(expRefLAddr, obsRefLAddr)
        
    def test_getNextRefIntervalInCaseOverLap(self):
        firstChildLAddr = -1
        firstRefLAddr = 120
        subEndLAddr = 144
        expRefLAddr, expSubEndLAddr = (96, 144)
        obsRefLAddr, obsSubEndLAddr = self._iFOWSI.getNextRefIntervalInCaseOverLap(firstChildLAddr, firstRefLAddr, subEndLAddr)
        self.assertEquals((expRefLAddr, expSubEndLAddr), (obsRefLAddr, obsSubEndLAddr))        

    def test_not_findOverlapIter_between2RefIntervals(self):
        inputQueryGff3FileName = 'query2.gff3'
        self._writeQueryGff3File2(inputQueryGff3FileName)
        self._iFOWSI.setQueryGff3FileName(inputQueryGff3FileName)
        queryGff3Addr = 0
        firstRefLAddr = 0
        obsFirstOverlapLAddr = self._iFOWSI.findOverlapIter(queryGff3Addr, firstRefLAddr)
        expFirstOverlapLAddr = 24
        self.assertEquals(expFirstOverlapLAddr, obsFirstOverlapLAddr) 
        os.remove(inputQueryGff3FileName) 

    def _writeQueryGff3File2(self, fileName):
        f = open(fileName, 'w')
        f.write("chr1\tquery\ttest1\t1100\t1150\t126\t+\t.\tID=test1.1;Name=test1.1\n")
        f.write("chr1\tquery\ttest2\t1250\t1300\t781\t+\t.\tID=test1.2;Name=test1.2\n")
        f.close()  
        
    def _writeQueryGff3File(self, fileName):
        f = open(fileName, 'w')
        f.write("chr1\tquery\ttest1.1\t25\t150\t126\t+\t.\tID=test1.1;Name=test1.1\n")
        f.write("chr1\tquery\ttest1.2\t70\t850\t781\t+\t.\tID=test1.2;Name=test1.2\n")
        f.write("chr1\tquery\ttest1.3\t550\t850\t201\t+\t.\tID=test1.3;Name=test1.3\n")
        f.write("chr1\tquery\ttest1.4\t925\t1025\t101\t+\t.\tID=test1.4;Name=test1.4\n")
        f.write("chr1\tquery\ttest1.5\t1201\t1210\t10\t+\t.\tID=test1.5;Name=test1.5\n")
        f.write("chr1\tquery\ttest1.6\t1500\t1600\t101\t+\t.\tID=test1.6;Name=test1.6\n")
        f.close()
        
    def _writeGFF3File(self, fileName):
        f = open(fileName, "w")
        f.write("chr1\ttest\ttest2.1\t9\t1000\t1001\t+\t.\tID=test2.1;Name=test2.1\n")
        f.write("chr1\ttest\ttest2.2\t50\t350\t301\t+\t.\tID=test2.2;Name=test2.2\n")
        f.write("chr1\ttest\ttest2.3\t100\t600\t501\t+\t.\tID=test2.3;Name=test2.3\n")
        f.write("chr1\ttest\ttest2.4\t200\t450\t251\t+\t.\tID=test2.4;Name=test2.4\n")
        f.write("chr1\ttest\ttest2.5\t700\t950\t251\t+\t.\tID=test2.5;Name=test2.5\n")
        f.write("chr1\ttest\ttest2.6\t800\t900\t101\t+\t.\tID=test2.6;Name=test2.6\n")
        f.write("chr1\ttest\ttest2.7\t1200\t1300\t101\t+\t.\tID=test2.7;Name=test2.7\n")
        f.close()
        
if __name__ == "__main__":
    unittest.main()
