import unittest
import os
from commons.core.utils.FileUtils import FileUtils

TESTFILES_PATH = os.environ['REPET_PATH'] + '/SMART/Java/Python/TestFiles'

class Test_F_coordinatesToSequence(unittest.TestCase):

    def test_run(self):
        cmd = "python ../coordinatesToSequence.py -i %s/testC2S.gff3 -f gff3 -s %s/testC2S.fa -o testOut.fa -v 10 " % (TESTFILES_PATH, TESTFILES_PATH)
        os.system(cmd)
        obs = 'testOut.fa'
        exp = 'expOut.fa'
        self._writeExpOut(exp)
        self.assertTrue(FileUtils.isRessourceExists(obs))
        self.assertTrue(FileUtils.are2FilesIdentical(obs, exp))
        os.remove(obs)
        os.remove(exp)       

    def _writeExpOut(self, outputFileName):
        f = open(outputFileName, "w")
        f.write(">region0\n")
        f.write("CAACATTAGC\n")
        f.write(">region1\n")
        f.write("TTAGCCGGCC\n")
        f.write(">region2\n")
        f.write("GGCCGGCTAA\n")
        f.close()

if __name__ == "__main__":
    unittest.main()