import unittest
import os
from SMART.Java.Python.misc import Utils

class Test_F_selectByTag(unittest.TestCase):

    def setUp(self):
        self._inputFileName = "%s/SMART/Java/Python/TestFiles/inputMSWC1.gff3" % os.environ["REPET_PATH"]
        self._outputFileName = "outputSBT.gff3"
        self._expOutputFileName = "expSBT.gff3"

    def tearDown(self):
        os.remove(self._outputFileName)
        os.remove(self._expOutputFileName)

    def test_run_compulsory_option(self):
        cmd = 'python ../SelectByTag.py -i %s -f gff3 -g occurrence -o %s -v 0' % (self._inputFileName, self._outputFileName)
        os.system(cmd)
        self._writeExpDefault(self._expOutputFileName)
        self.assertTrue(Utils.diff(self._expOutputFileName, self._outputFileName))
        
    def test_run_value_option(self):
        cmd = 'python ../SelectByTag.py -i %s -f gff3 -a 1 -g occurrence -o %s -v 0' % (self._inputFileName, self._outputFileName)
        os.system(cmd)
        self._writeExpValueOption(self._expOutputFileName)
        self.assertTrue(Utils.diff(self._expOutputFileName, self._outputFileName))
        
    def test_run_min_option(self):
        cmd = 'python ../SelectByTag.py -i %s -f gff3 -m 3 -g occurrence -o %s -v 0' % (self._inputFileName, self._outputFileName)
        os.system(cmd)
        self._writeExpMinOption(self._expOutputFileName)
        self.assertTrue(Utils.diff(self._expOutputFileName, self._outputFileName))
    
    def test_run_max_option(self):
        cmd = 'python ../SelectByTag.py -i %s -f gff3 -M 1 -g occurrence -o %s -v 0' % (self._inputFileName, self._outputFileName)
        os.system(cmd)
        self._writeExpMaxOption(self._expOutputFileName)
        self.assertTrue(Utils.diff(self._expOutputFileName, self._outputFileName))

    def test_run_max_min_option(self):
        cmd = 'python ../SelectByTag.py -i %s -f gff3 -M 2 -m 1 -g occurrence -o %s -v 0' % (self._inputFileName, self._outputFileName)
        os.system(cmd)
        self._writeExpMaxMinOption(self._expOutputFileName)
        self.assertTrue(Utils.diff(self._expOutputFileName, self._outputFileName))
        
    def _writeExpDefault(self, fileName):
        f = open(fileName, 'w')
        f.write("""chr1	S-MART	match	6155418	6155441	24	+	.	occurrence=1;rank=1;bestRegion=(self);nbGaps=0;nbOccurrences=1;nbMismatches=0;ID=test1/1;identity=100;Name=test1/1
chr2	S-MART	match	26303950	26303981	32	+	.	occurrence=1;rank=1;bestRegion=(self);nbGaps=0;nbOccurrences=3;nbMismatches=2;ID=test2/1-1;identity=93;Name=test2/1
chr3	S-MART	match	28320540	28320574	35	+	.	occurrence=2;bestRegion=chr2:26303950-26303981;nbGaps=0;nbOccurrences=3;nbMismatches=2;ID=test2/1-2;identity=94;Name=test2/1
chr4	S-MART	match	28565007	28565041	35	+	.	occurrence=3;rank=3;bestRegion=chr2:26303950-26303981;nbGaps=0;nbOccurrences=3;nbMismatches=4;ID=test2/1-3;identity=88;Name=test2/1
chr6	S-MART	match	48565007	48565041	35	+	.	occurrence=3;rank=3;bestRegion=chr2:26303950-26303981;nbGaps=0;nbOccurrences=3;nbMismatches=3;ID=test2/1-4;identity=80;Name=test2/1
""")
        f.close()
        
    def _writeExpValueOption(self, fileName):
        f = open(fileName, 'w')
        f.write("""chr1	S-MART	match	6155418	6155441	24	+	.	occurrence=1;rank=1;bestRegion=(self);nbGaps=0;nbOccurrences=1;nbMismatches=0;ID=test1/1;identity=100;Name=test1/1
chr2	S-MART	match	26303950	26303981	32	+	.	occurrence=1;rank=1;bestRegion=(self);nbGaps=0;nbOccurrences=3;nbMismatches=2;ID=test2/1-1;identity=93;Name=test2/1
""")
        f.close()
        
    def _writeExpMinOption(self, fileName):
        f = open(fileName, 'w')
        f.write("""chr4	S-MART	match	28565007	28565041	35	+	.	occurrence=3;rank=3;bestRegion=chr2:26303950-26303981;nbGaps=0;nbOccurrences=3;nbMismatches=4;ID=test2/1-3;identity=88;Name=test2/1
chr6	S-MART	match	48565007	48565041	35	+	.	occurrence=3;rank=3;bestRegion=chr2:26303950-26303981;nbGaps=0;nbOccurrences=3;nbMismatches=3;ID=test2/1-4;identity=80;Name=test2/1
""")
        f.close()
        
    def _writeExpMaxOption(self, fileName):
        f = open(fileName, 'w')
        f.write("""chr1	S-MART	match	6155418	6155441	24	+	.	occurrence=1;rank=1;bestRegion=(self);nbGaps=0;nbOccurrences=1;nbMismatches=0;ID=test1/1;identity=100;Name=test1/1
chr2	S-MART	match	26303950	26303981	32	+	.	occurrence=1;rank=1;bestRegion=(self);nbGaps=0;nbOccurrences=3;nbMismatches=2;ID=test2/1-1;identity=93;Name=test2/1
""")
        f.close()        
        
    def _writeExpMaxMinOption(self, fileName):
        f = open(fileName, 'w')
        f.write("""chr1	S-MART	match	6155418	6155441	24	+	.	occurrence=1;rank=1;bestRegion=(self);nbGaps=0;nbOccurrences=1;nbMismatches=0;ID=test1/1;identity=100;Name=test1/1
chr2	S-MART	match	26303950	26303981	32	+	.	occurrence=1;rank=1;bestRegion=(self);nbGaps=0;nbOccurrences=3;nbMismatches=2;ID=test2/1-1;identity=93;Name=test2/1
chr3	S-MART	match	28320540	28320574	35	+	.	occurrence=2;bestRegion=chr2:26303950-26303981;nbGaps=0;nbOccurrences=3;nbMismatches=2;ID=test2/1-2;identity=94;Name=test2/1
""")
        f.close()
        
if __name__ == "__main__":
    unittest.main()
