import re
import sys
from parser.mapperParser import *


class SeqmapParser(MapperParser):
  """A class that parses the output of SeqMap"""

  def __init__(self, fileName, verbosity = 0):
    super(SeqmapParser, self).__init__(fileName, verbosity)


  def __del__(self):
    super(SeqmapParser, self).__del__()


  def skipFirstLines(self):
    self.startingPoint   = self.handle.tell()
    if "trans_id" not in self.handle.readline():
      self.handle.seek(self.startingPoint)
    self.startingPoint   = self.handle.tell()


  def parseLine(self, line):
    m = re.search(r"^\s*(\S+)\t+(\d+)\t+(\w+)\t+([^\t]+)\t+(\w+)\t+(\d+)\t+([+-])\s*$", line)
    if m == None:
      sys.exit("Line " + line + " does not look like a SeqMap line")

    mapping = Mapping()

    mapping.targetInterval.setChromosome(m.group(1))
    mapping.targetInterval.setStart(int(m.group(2)))
    mapping.targetInterval.setSize(len(m.group(3)))

    mapping.queryInterval.setName(m.group(4))
    mapping.queryInterval.setStart(1)
    mapping.queryInterval.setSize(len(m.group(3)))

    mapping.setSize(len(m.group(3)))
    mapping.setNbMismatches(int(m.group(6)))
    mapping.setDirection(m.group(7))

    return mapping

