import unittest
import time
from SMART.Java.Python.ncList.test.MockFindOverlaps_randomExample import *
from SMART.Java.Python.FindOverlapsOptim import FindOverlapsOptim

class Test_F_FindOverlaps_randomExample(unittest.TestCase):

    def setUp(self):
        self._output_optim = 'output_optim.gff3'
        
    def test_creatRandomExampleWithMOverlaps(self):
        inputRefGff3FileName = 'refMOverlaps.gff3'
        inputQueryGff3FileName = 'queryMOverlaps.gff3'
        outputDataName = 'timeResult.dat'  
        fTime = open(outputDataName, 'w')  
        fTime.write('NbRef\tNbQuery\tNbOverlap\ttime\n')   
        numberOfRefReads = 1000
        chromSize = 100000
        while numberOfRefReads <= 1000:
            numberOfQReads = 1000
            while numberOfQReads <= 1000:
                print 'ref size = %d,  query size = %d' %(numberOfRefReads, numberOfQReads)
                iMFOR_ref = MockFindOverlaps_randomExample(inputRefGff3FileName, 'ref', numberOfRefReads, chromSize)
                iMFOR_ref.write()
                iMFOR_query = MockFindOverlaps_randomExample(inputQueryGff3FileName,'q', numberOfQReads, chromSize)
                iMFOR_query.write()
                iFOO = FindOverlapsOptim(0)
                iFOO.setRefFileName(inputRefGff3FileName, "gff3")
                iFOO.setQueryFileName(inputQueryGff3FileName, "gff3")
                iFOO.setOutputFileName(self._output_optim)
                iFOO.prepareIntermediateFiles()
                iFOO.createNCLists()
                
                startTime_optim = time.time()
                iFOO.compare()
                endTime_optim = time.time()
                totalTime_optim = endTime_optim - startTime_optim
                print 'we took %s second.' % (totalTime_optim)
                nbOverlap = iFOO._nbOverlaps
                iFOO.close()  
                fTime.write('%d\t%d\t%d\t%.2f\n' % (numberOfRefReads, numberOfQReads, nbOverlap, totalTime_optim))
                numberOfQReads *= 10
            numberOfRefReads *= 10
        fTime.close()
        os.remove(inputQueryGff3FileName)
        os.remove(inputRefGff3FileName)
        os.remove(self._output_optim)
        
        
if __name__ == "__main__":
    unittest.main()
