# Copyright INRA (Institut National de la Recherche Agronomique)
# http://www.inra.fr
# http://urgi.versailles.inra.fr
#
# This software is governed by the CeCILL license under French law and
# abiding by the rules of distribution of free software.  You can  use, 
# modify and/ or redistribute the software under the terms of the CeCILL
# license as circulated by CEA, CNRS and INRIA at the following URL
# "http://www.cecill.info". 
#
# As a counterpart to the access to the source code and  rights to copy,
# modify and redistribute granted by the license, users are provided only
# with a limited warranty  and the software's author,  the holder of the
# economic rights,  and the successive licensors  have only  limited
# liability. 
#
# In this respect, the user's attention is drawn to the risks associated
# with loading,  using,  modifying and/or developing or reproducing the
# software by the user in light of its specific status of free software,
# that may mean  that it is complicated to manipulate,  and  that  also
# therefore means  that it is reserved for developers  and  experienced
# professionals having in-depth computer knowledge. Users are therefore
# encouraged to load and test the software's suitability as regards their
# requirements in conditions enabling the security of their systems and/or 
# data to be ensured and,  more generally, to use and operate it in the 
# same conditions as regards security. 
#
# The fact that you are presently reading this means that you have had
# knowledge of the CeCILL license and that you accept its terms.


import unittest
from SMART.Java.Python.structure.Sequence import Sequence


class Test_Sequence(unittest.TestCase):
    
    def setUp(self):
        self._bs = Sequence()
        self._bs1 = Sequence()
    
    def test_getSize(self):
        self._bs.setName("sequence1")
        self._bs.setSequence("AGCGGACGATGCAGCATGCGAATGACGATA")
        obsSize = self._bs.getSize()
        expSize = 30
        self.assertEquals( expSize, obsSize )   
    
    def test_concatenate(self):
        self._bs.setName("sequence")
        self._bs.setSequence("GATGTGCAGACTTTTCACGCAGGACTACATCACTGT")
        self._bs.setQuality("WWWVVVWPWWWVWWWWVVVVKVPWWVVWVWUUQUTQ")
        self._bs1.setName("sequence1")
        self._bs1.setSequence("GGAAACATATGCACATAAACGTTGAAATCATGCTTA")
        self._bs1.setQuality("WWWWWWWWWWWWWWWWWVWWVWWVWWWWWWUUUUUU")
        self._bs.concatenate(self._bs1)
        expSeq = "GATGTGCAGACTTTTCACGCAGGACTACATCACTGTGGAAACATATGCACATAAACGTTGAAATCATGCTTA"
        expQal = "WWWVVVWPWWWVWWWWVVVVKVPWWVVWVWUUQUTQWWWWWWWWWWWWWWWWWVWWVWWVWWWWWWUUUUUU"
        self.assertEquals(expSeq, self._bs.getSequence())
        self.assertEquals(expQal, self._bs.getQuality())

    def test_reverseComplement(self):
        self._bs.setName("seq1")
        self._bs.setSequence("TACGGC")
        exp = "GCCGTA"
        self._bs.reverseComplement()
        obs = self._bs.getSequence()
        self.assertEquals(exp, obs)

    def test_containsAmbiguousNucleotides(self):
        self._bs.setName("seq1")
        self._bs.setSequence("WCGTUacgtu")
        self.assertTrue (self._bs.containsAmbiguousNucleotides())

    def test_shrinkToFirstNucleotides(self):
        self._bs.setName("seq1")
        self._bs.setSequence("WCGTUacgtu")
        self._bs.shrinkToFirstNucleotides(3)
        expSeq = "WCG"
        self.assertEquals(expSeq, self._bs.getSequence())
        
    def test_shrinkToLastNucleotides(self):
        self._bs.setName("seq1")
        self._bs.setSequence("WCGTUacgtu")
        self._bs.shrinkToLastNucleotides(5)
        expSeq = "acgtu"
        self.assertEquals(expSeq, self._bs.getSequence())
        
if __name__ == "__main__":
    unittest.main()
