import unittest
from commons.core.parsing.VarscanToVCF import VarscanToVCF

class Test_VarscanToVCF(unittest.TestCase):
    
    def setUp(self):
        self._iVarscanToVCF = VarscanToVCF(doClean = True, verbosity = 2)
    
#    def test_convertVarscanLineToVCFRecord(self):
##        Chrom    Position    Ref    Cons    Reads1    Reads2    VarFreq    Strands1    Strands2    Qual1    Qual2    Pvalue           
##        chr1    10            C        Y        1        1        50%        1            1            68    69    0.49999999999999994
##     MapQual1    MapQual2    Reads1Plus    Reads1Minus    Reads2Plus    Reads2Minus    VarAllele
##             1           1            1            0            1            0                T
#        varscanLine = "chr1\t10\tC\tY\t1\t1\t50%\t1\t1\t68\t69\t0.49999999999999994\t1\t1\t1\t0\t1\t0\tT"
#        obsRecord = self._iVarscanToVCF._convertVarscanLineToVCFRecord(varscanLine, 1)
#        
#        expInfo = {"AF": "50%",
#                   "DP": 2,
#                   "MQ": "1"}
#
#        expRecord = vcf.model._Record("chr1", 10, "1", "C", "T", 3.010299957, ".", expInfo, ".", None)
##        CHROM, POS, ID, REF, ALT, QUAL, FILTER, INFO, FORMAT, sample_indexes, samples=None
#        
#        self.assertEqual(expRecord.ID, obsRecord.ID)
#        self.assertEqual(expRecord.QUAL, obsRecord.QUAL)
#        self.assertEqual(expRecord.FILTER, obsRecord.FILTER)
#        self.assertEqual(expRecord.INFO, obsRecord.INFO)
#        self.assertEqual(expRecord.FORMAT, obsRecord.FORMAT)
#        self.assertEqual(expRecord, obsRecord)
    
    def test_convertVarscanLineToVCFLine(self):
#        Chrom    Position    Ref    Cons    Reads1    Reads2    VarFreq    Strands1    Strands2    Qual1    Qual2    Pvalue           
#        chr1    10            C        Y        1        1        50%        1            1            68    69    0.49999999999999994
#     MapQual1    MapQual2    Reads1Plus    Reads1Minus    Reads2Plus    Reads2Minus    VarAllele
#             1           1            1            0            1            0                T
        varscanLine = "chr1\t10\tC\tY\t1\t1\t50%\t1\t1\t68\t69\t0.49999999999999994\t1\t1\t1\t0\t1\t0\tT"
        obsVCFLine = self._iVarscanToVCF._convertVarscanLineToVCFRecord(varscanLine, 1)
        
        expVCFLine = "chr1\t10\t.\tC\tT\t3.010299957\t.\tAF=0.5000;DP=2;RBQ=68;ABQ=69\n"
        #        CHROM, POS, ID, REF, ALT, QUAL, FILTER, INFO
        self.assertEqual(expVCFLine, obsVCFLine)
        
    def test_convertVarscanLineToVCFLine_false_VarAllele(self):
        varscanLine = "chr1\t10\tC\tY\t1\t1\t50%\t1\t1\t68\t69\t0.49999999999999994\t1\t1\t1\t0\t1\t0\tA"
        obsVCFLine = self._iVarscanToVCF._convertVarscanLineToVCFRecord(varscanLine, 1)
        
        expVCFLine = "chr1\t10\t.\tC\tT\t3.010299957\t.\tAF=0.5000;DP=2;RBQ=68;ABQ=69\n"
        #        CHROM, POS, ID, REF, ALT, QUAL, FILTER, INFO
        self.assertEqual(expVCFLine, obsVCFLine)
        
    def test_convertVarscanLineToVCFRecord_empty_line(self):
        obsMsg = ""
        try:
            self._iVarscanToVCF._convertVarscanLineToVCFRecord("", 10)
        except Exception as e:
            obsMsg = e.msg
        
        self.assertEqual("This varscan line (l.10) is not complete", obsMsg)

if __name__ == "__main__":
    unittest.main()