# MAplotDE
# MAplot of DE genes

# input : res, alpha,OUT_MAplotDEName 
# output : MAplot (png)

MAplotDE <- function( res, alpha, OUT_MAplotDEName, out = TRUE ){

 	if (out) png( file=OUT_MAplotDEName )
  
 	plot( res$baseMean, res$log2FoldChange, pch=".", xlab="Mean expression", ylab="log2FC", main="",
  		log="x", col=ifelse(res$padj < alpha, "red", "black") )
	abline(h=0, col="red")

  	if (out) dev.off()
}
