import unittest
import os
import time
from commons.core.utils.FileUtils import FileUtils
from SMART.Java.Python.ncList.test.MockFindOverlaps_randomExample import MockFindOverlaps_randomExample_NonOrder
from SMART.Java.Python.ncList.FindOverlaps_naif import FindOverlaps_naif
from SMART.Java.Python.FindOverlapsOptim import FindOverlapsOptim

class Test_F_FindOverlaps_randomExample(unittest.TestCase):

    def setUp(self):
        self._output_optim = 'output_optim.gff3'

    def test_FindOverlaps_NonOrder(self):
        inputRefGff3FileName = 'refMOverlaps.gff3'
        inputQueryGff3FileName = 'queryMOverlaps.gff3'
        outputDataName = 'timeResult.dat'  
        fTime = open(outputDataName, 'w')  
        fTime.write('NbRef\tNbQuery\tNbOverlap\ttime\n')   
        numberOfRefReads = 10
        chromSize = 100000
        numberOfQReads = 10
        print 'ref size = %d,  query size = %d' %(numberOfRefReads, numberOfQReads)
        iMFOR_ref = MockFindOverlaps_randomExample_NonOrder(inputRefGff3FileName, 'ref', numberOfRefReads, chromSize)
        iMFOR_ref.write()
        iMFOR_query = MockFindOverlaps_randomExample_NonOrder(inputQueryGff3FileName,'q', numberOfQReads, chromSize)
        iMFOR_query.write()
        iFOO = FindOverlapsOptim(0)
        iFOO.setRefFileName(inputRefGff3FileName, "gff3")
        iFOO.setQueryFileName(inputQueryGff3FileName, "gff3")
        iFOO.setOutputFileName(self._output_optim)
        startTime_optim = time.time()
        iFOO.run()
        iFOO.close()  
        nbOverlap = iFOO._nbOverlaps
        endTime_optim = time.time()    
        totalTime_optim = endTime_optim - startTime_optim
        print 'we take %s second.' % (totalTime_optim)
        fTime.write('%d\t%d\t%d\t%.2f\n'%(numberOfRefReads, numberOfQReads, nbOverlap, totalTime_optim))
        fTime.close()
        os.remove(inputQueryGff3FileName)
        os.remove(inputRefGff3FileName)
        os.remove(self._output_optim)  
        os.remove(outputDataName)      
        
        
if __name__ == "__main__":
    unittest.main()
