import re
import sys
from parsing.mapperParser import *

class MummerParser(MapperParser):
  """A class that parses the output of Mummer format"""

  def __init__(self, fileName, verbosity = 0):
    super(MummerParser, self).__init__(fileName, verbosity)


  def __del__(self):
    super(MummerParser, self).__del__()


  def getFileFormats():
    return ["mummer"]
  getFileFormats = staticmethod(getFileFormats)


  def skipFirstLines(self):
    pass


  def parseLine(self, line):
    mapping = Mapping()

    subMapping = SubMapping()

    # handle header
    m = re.search(r"^>\s+(\S+)\s+Reverse\s+Len\s+=\s+(\d+)$", line)
    if m != None:
      subMapping.queryInterval.name      = m.group(1)
      subMapping.queryInterval.size      = int(m.group(2))
      subMapping.queryInterval.direction = -1
    else:
      m = re.search(r"^>\s+(\S+)\s+Len\s+=\s+(\d+)$", line)
      if m != None:
        subMapping.queryInterval.name      = m.group(1)
        subMapping.queryInterval.size      = int(m.group(2))
        subMapping.queryInterval.direction = 1
      else :
        sys.exit("Header line %d '%s' is strange in Mummer file" % (self.currentLineNb, line))

    for line in self.handle:
      self.currentLineNb += 1
      break
    line = line.strip()

    # handle line
    m = re.search(r"^(\w+)\s+(\d+)\s+(\d+)\s+(\d+)$", line)
    if m != None:
      subMapping.targetInterval.name  = m.group(1)
      subMapping.targetInterval.start = int(m.group(2))
      subMapping.queryInterval.start  = int(m.group(3))
      subMapping.targetInterval.size  = int(m.group(4))
    else:
      sys.exit("Line %d '%s' is strange in Mummer file" % (self.currentLineNb, line))

    mapping.addSubMapping(subMapping)

    return mapping
