/**
 *
 * Copyright INRA-URGI 2009-2010
 * 
 * This software is governed by the CeCILL license under French law and
 * abiding by the rules of distribution of free software. You can use,
 * modify and/ or redistribute the software under the terms of the CeCILL
 * license as circulated by CEA, CNRS and INRIA at the following URL
 * "http://www.cecill.info".
 * 
 * As a counterpart to the access to the source code and rights to copy,
 * modify and redistribute granted by the license, users are provided only
 * with a limited warranty and the software's author, the holder of the
 * economic rights, and the successive licensors have only limited
 * liability.
 * 
 * In this respect, the user's attention is drawn to the risks associated
 * with loading, using, modifying and/or developing or reproducing the
 * software by the user in light of its specific status of free software,
 * that may mean that it is complicated to manipulate, and that also
 * therefore means that it is reserved for developers and experienced
 * professionals having in-depth computer knowledge. Users are therefore
 * encouraged to load and test the software's suitability as regards their
 * requirements in conditions enabling the security of their systems and/or
 * data to be ensured and, more generally, to use and operate it in the
 * same conditions as regards security.
 * 
 * The fact that you are presently reading this means that you have had
 * knowledge of the CeCILL license and that you accept its terms.
 *
 */
import java.io.*;
import java.util.*;

public class PythonProgramFinder {

  String             dirName;
  Vector < Program > programs;

  public PythonProgramFinder(String dirName) {
    this.dirName = dirName;  
  }

  public String findPrograms() {
    java.io.File directory = new java.io.File(this.dirName);
    String[] files         = directory.list(new FilenameFilter() {public boolean accept(java.io.File dir, String name) {return ((! name.startsWith(".")) && (! name.startsWith("test")) && ((new java.io.File(dir, name)).isFile()) && (name.endsWith(".py")) && (name.compareToIgnoreCase("__init__.py") != 0));}});
    this.programs          = new Vector < Program > ();

    for (int i = 0; i < files.length; i++) {
      String[] commandList  = {Global.pythonCommand, "Python" + java.io.File.separator + files[i], "-h"};
      String command = "";
      for (int j = 0; j < commandList.length; j++) {
        command += commandList[j] + " ";
      }
      ProcessBuilder pb = new ProcessBuilder(commandList);
      pb = pb.redirectErrorStream(true);
      Map<String, String> env = pb.environment();
      env.put("PYTHONPATH", System.getProperty("user.dir") + java.io.File.separator + "Python");
      env.put("SMARTPATH", System.getProperty("user.dir") + java.io.File.separator + "Python");
      env.put("SMARTMYSQLPATH", Global.mysqlCommand);
      env.put("SMARTRPATH", Global.rCommand);

      PythonHelperReader helperReader = new PythonHelperReader(files[i]);
      try {
        final Process process = pb.start();
        InputStream is        = process.getInputStream();
        InputStreamReader isr = new InputStreamReader(is);
        BufferedReader br     = new BufferedReader(isr);
        helperReader.setReader(br);
        helperReader.run();
      }
      catch (IOException e) {
        final Writer result = new StringWriter();
        final PrintWriter printWriter = new PrintWriter(result);
        e.printStackTrace(printWriter);
        return "Command '" + command + "' failed (I/O error)...\n" + result.toString();
      }
      String comments = helperReader.getMessage();
      if (comments != null) return comments;
      Program program = helperReader.getProgram();
      if (("Personnal".compareToIgnoreCase(program.getSection()) != 0) && ("Personal".compareToIgnoreCase(program.getSection()) != 0)) {
        this.programs.add(program);
      }
    }
    return null;
  }

  public Vector <Program> getPrograms () {
    return this.programs;
  }
}

