from pyRepet.coord.Map import Map
import commons.core.sql.TablePathAdaptator


## Connect overlapping chunks in a single fragment  
#
class PathChunkConnector( object):
    
    def __init__(self, mapFileName, db, table, verbose):
       
        self._verbose = verbose
        self._chunk = self._getChunkDictFromMapFileForConnectPathChunks( mapFileName )
        self._tablePathAdaptator = commons.core.sql.TablePathAdaptator.TablePathAdaptator( db, table )
    
    def run (self):
        for num_chunk in xrange(1,len(self._chunk.keys())):
            chunkName = "chunk"+str(num_chunk)
            if self._verbose > 1:
                print chunkName
            next_chunkName="chunk"+str(num_chunk+1)
    
            if next_chunkName not in self._chunk.keys():
                break
            
            start=self._chunk[chunkName][2]
            end=self._chunk[next_chunkName][1]
            
            if self._chunk[chunkName][0] == self._chunk[next_chunkName][0]:
                lpath=self._tablePathAdaptator.getPathListIncludedInQueryCoord(self._chunk[chunkName][0],start,end)
            
                if self._verbose > 1:
                    print "----------"
                
                lpath.sort()
                chg_path_id={}
                pathnum_to_ins=[]
                pathnum_to_del=[]
                
                self._createDirectAndReversePaths(lpath)
                        
                self._mergeDirectPaths(chg_path_id, pathnum_to_ins, pathnum_to_del)
                
                if self._verbose > 1:
                    print "..........."
     
                self._mergeReversePaths(chg_path_id, pathnum_to_ins, pathnum_to_del)
                
                if self._verbose > 1:
                    print "..........."
                    print pathnum_to_del
                    
                self._tablePathAdaptator.deleteFromIdList(pathnum_to_del)
                
                if self._verbose > 1:
                    print pathnum_to_ins
                
                self._tablePathAdaptator.deleteFromIdList(pathnum_to_ins)
                
                self._insertDirectPaths(chg_path_id, pathnum_to_ins)
               
                self._insertReversePaths(chg_path_id, pathnum_to_ins)
    

    def _createDirectAndReversePaths(self, lpath):
        self._dpath = []
        self._rpath = []
        for i in lpath:
            if i.range_query.isOnDirectStrand() and i.range_subject.isOnDirectStrand():
                self._dpath.append(i)
            else:
                self._rpath.append(i)
                
    def _insertDirectPaths (self, chg_path_id, pathnum_to_ins):
        self._insertPaths(chg_path_id, pathnum_to_ins, self._dpath)

    def _insertReversePaths (self, chg_path_id, pathnum_to_ins):
        self._insertPaths(chg_path_id, pathnum_to_ins, self._rpath)

    def _insertPaths(self, chg_path_id, pathnum_to_ins, paths2Insert):
        for i in paths2Insert:
            if chg_path_id.has_key(i.id):
                i.id = chg_path_id[i.id]
            
            if self._verbose > 1:
                i.show()
            
            if i.id in pathnum_to_ins:
                self._tablePathAdaptator.insert(i)
                if self._verbose > 1:
                    print "--> inserted!"
            
            if self._verbose > 1:
                print "=========="
    
    def _mergeDirectPaths(self, chg_path_id, pathnum_to_ins, pathnum_to_del):
        self._mergePaths(chg_path_id, pathnum_to_ins, pathnum_to_del, self._dpath)
    
    def _mergeReversePaths(self, chg_path_id, pathnum_to_ins, pathnum_to_del):
        self._mergePaths(chg_path_id, pathnum_to_ins, pathnum_to_del, self._rpath)
            
    def _mergePaths(self, chg_path_id, pathnum_to_ins, pathnum_to_del, dpath):
        x = 0
        while x < len(dpath) - 1:
            x = x + 1
            if self._verbose > 1:
                print "++++"
                dpath[x - 1].show()
                dpath[x].show()
            
            if dpath[x - 1].canMerge(dpath[x]):
                chg_path_id[dpath[x].id] = dpath[x - 1].id
                if dpath[x - 1].id not in pathnum_to_ins:
                    pathnum_to_ins.append(dpath[x - 1].id)
                
                if dpath[x].id not in pathnum_to_del:
                    pathnum_to_del.append(dpath[x].id)
                
                dpath[x - 1].merge(dpath[x])
                del dpath[x]
                x = x - 1
                if self._verbose > 1:
                    print "--> merged"
                
    def _getChunkDictFromMapFileForConnectPathChunks(self, mapFileName):
        mapDict = {}
        mapFile = open(mapFileName)
        mapInstance = Map()
        while True:
            if not mapInstance.read(mapFile):
                break
            mapDict[mapInstance.name] = (mapInstance.seqname, mapInstance.start, mapInstance.end)
            
        mapFile.close()
        return mapDict
