#!/usr/bin/env python

from commons.pyRepetUnit.fastaTranslation.allFrames.TranslateInAllFramesAndReplaceStopByX import TranslateInAllFramesAndReplaceStopByX
from commons.core.utils.FileUtils import FileUtils
import os
import sys
import getopt

#------------------------------------------------------------------------------

def help():

    """
    Give the command-line parameters.
    """

    print ""
    print "usage: ",sys.argv[0],"[ options ]"
    print "options:"
    print "     -h: this help"
    print "     -i: name of the nucleotidic input file (format='fasta')"
    print "     -o: name of the output file (default=inFileName+'_aa')"
    print "     -v: verbose (default=0/1/2)"
    print "     -c: clean"
    print ""

#------------------------------------------------------------------------------

def main():

    inFileName = ""
    outFileName = ""
    verbose = 0
    clean = False

    try:
        opts = getopt.getopt(sys.argv[1:],"hi:o:v:c")[0]
    except getopt.GetoptError, err:
        print str(err)
        help()
        sys.exit(1)
    for o,a in opts:
        if o == "-h":
            help()
            sys.exit(0)
        elif o == "-i":
            inFileName = a
        elif o == "-o":
            outFileName = a
        elif o == "-v":
            verbose = int(a)
        elif o == "-c":
            clean = True
            
    if inFileName == "":
        print "*** Error: missing compulsory options"
        help()
        sys.exit(1)

    if verbose > 0:
        print "beginning of %s" % (sys.argv[0].split("/")[-1])
        sys.stdout.flush()

    if outFileName == "":
        outFileName = "%s_aa" % ( inFileName )
    
    iTIAFARSBX = TranslateInAllFramesAndReplaceStopByX()
    iTIAFARSBX.setInputFile( inFileName )
    iTIAFARSBX.setOutputFile( outFileName )
    iTIAFARSBX.run( )
    
    if clean == True:
        os.remove( inFileName )

    if verbose > 0:
        if FileUtils.isRessourceExists( outFileName ) and not(FileUtils.isEmpty( outFileName )):
            print "%s finished successfully" % (sys.argv[0].split("/")[-1])
            sys.stdout.flush()
        else:
            print "warning %s execution failed" % (sys.argv[0].split("/")[-1])
            sys.stdout.flush()

    return 0

#------------------------------------------------------------------------------

if __name__ == '__main__':
    main()