'''
Created on 14 avr. 2009

@author: oinizan
'''
import re
from commons.core.checker.IChecker import IChecker
from commons.core.checker.OldConfigChecker import ConfigChecker
from commons.core.checker.ConfigException import ConfigException
from commons.core.checker.CheckerException import CheckerException

class DetectFeatureConfigChecker (IChecker):
    '''
    classdocs
    '''
    def __init__(self):
        '''
        Constructor
        '''
        self._dict = {"te_hmmer" : "", 
                      "te_blrn" : ""                                  
        }
        self._specifiqueDict = {"te_hmmer_evalue" : "",
                                "te_hmm_profiles" : ""                
        }

    def _appendMessageToConfigExceptionMessage(self, messages):
        appendedMessages = []
        for msg in messages:
            if (re.match("\[detect_features\] - No option 'te_hmm_profiles' in section: 'detect_features'", msg)):
                appendedMessages.append(msg + " whereas te_hmmer is set")
            
            if (re.match("\[detect_features\] - No option 'te_hmmer_evalue' in section: 'detect_features'", msg)):
                appendedMessages.append(msg + " whereas te_hmmer is set - Default value will be set")

        return appendedMessages

        
    def check(self, configFile):
        chk = ConfigChecker("detect_features", self._dict)
        try :
            chk.check(configFile)
        except ConfigException, e :
            raise e

        if self._dict["te_hmmer"] == "yes":                  
            isErrorOccured = False
            try:
                chk = ConfigChecker("detect_features", self._specifiqueDict)
                chk.check(configFile)                
            except ConfigException, e:
                appendedMessages = self._appendMessageToConfigExceptionMessage(e.messages) 
                raise ConfigException("", appendedMessages)    
                        
        
if __name__ == "__main__":                 
    pass
