import os
import unittest
from commons.pyRepetUnit.hmmer.hmmOutput.HmmpfamOutputProcessing import HmmpfamOutputProcessing
from commons.core.utils.FileUtils import FileUtils

class TestHmmpfamOutputProcessing(unittest.TestCase):
    
    def setUp(self):
        self.fileUtils = FileUtils()
        self.hmmpfamOutputProcess = HmmpfamOutputProcessing()
        self._inputFile = "./datas/Outputhmmpfam" 
        self._inputFile2 = "./datas/test_hmmpfam_output"
        self._outputFile = "./datas/dummyAlignFile.align"
        
    def testReadHmmOutput(self):
        file = open( self._inputFile )
        pfamOutput = self.hmmpfamOutputProcess.readHmmOutput(file)
        self.assertEqual(["7LES_DROME", "437", "522", "fn3", "1", "84", "8.8e-15", "48.3"], pfamOutput.get(0))
        self.assertEqual(["7LES_DROME", "825", "914", "fn3", "1", "84", "2.2e-06", "13.4"], pfamOutput.get(1))
        self.assertEqual(["7LES_DROME", "1292", "1389", "fn3", "1", "84", "1.2e-06", "15.9"], pfamOutput.get(2))
        self.assertEqual(["7LES_DROME", "1799", "1891", "fn3", "1", "84", "2.3e-19", "63.5"], pfamOutput.get(3))
        self.assertEqual(["7LES_DROME", "1899", "1978", "fn3", "1", "84", "1.5e-06", "15.2"], pfamOutput.get(4))
        self.assertEqual(["7LES_DROME", "1993", "2107", "fn3", "1", "84", "4.3e-07", "20.3"], pfamOutput.get(5))
        self.assertEqual(["7LES_DROME", "2209", "2483", "pkinase", "1", "294", "6e-95", "314.6"], pfamOutput.get(6))
        self.assertEqual(["7LES_DROME", "2223", "2284", "rrm", "1", "77", "0.72", "-40.4"], pfamOutput.get(7))
        file.close()
        
    def test_readHmmOutput_empty_file(self):
        file = open( "./datas/OutputhmmpfamEmpty", "w" )
        file.close()
        file = open( "./datas/OutputhmmpfamEmpty")
        pfamOutput = self.hmmpfamOutputProcess.readHmmOutput(file)
        file.close()
        self.assertEqual(None, pfamOutput)
        os.system("rm ./datas/OutputhmmpfamEmpty")
        
    def testParseHmmpfamOutput2Align(self):
        self.hmmpfamOutputProcess.readHmmOutputsAndWriteAlignFile(self._inputFile2, self._outputFile)
        self.assertTrue(FileUtils.isRessourceExists(self._outputFile))
        self.assertEqual(18, FileUtils.getNbLinesInSingleFile(self._outputFile))
        os.system("rm " + self._outputFile)
        
    def test_parseHmmpfamOutput2Align_empty_file(self):
        file = open("./datas/dummy_hmmpfam_output", "w")
        file.close()
        self._inputFile = "./datas/dummy_hmmpfam_output"
        self.hmmpfamOutputProcess.readHmmOutputsAndWriteAlignFile( self._inputFile, self._outputFile )
        self.assertTrue(FileUtils.isEmpty(self._outputFile))
        os.system("rm " + self._inputFile)
        os.system("rm " + self._outputFile)
        
    def test_parseHmmpfamOutput2Align_file_not_exists(self):
        self._inputFile = "./datas/dummy_hmmpfam_output"
        self.hmmpfamOutputProcess.readHmmOutputsAndWriteAlignFile(self._inputFile, self._outputFile )
        self.assertFalse(FileUtils.isRessourceExists(self._outputFile))
        
if __name__ == "__main__":                 
    unittest.main()