import os
import unittest
from commons.pyRepetUnit.hmmer.hmmOutput.HmmscanOutputProcessing import HmmscanOutputProcessing
from commons.core.utils.FileUtils import FileUtils

class TestHmmscanOutputProcessing(unittest.TestCase):
    
    def setUp(self):
        self.hmmscanOutputProcess = HmmscanOutputProcessing()
        self._inputFile = "./datas/hmmscanOutputTab.txt"
        self._inputFileScan2 = "./datas/hmmscanOutput" 
        self._outputFileScan2 = "./datas/hmmscanOutput.align"
        self._outputFile = "./datas/dummyFile.align"
        
    def tearDown(self):
        if os.path.exists(self._outputFile):
            os.remove(self._outputFile)
        
    def testReadHmmerscanOutput(self):
        file = open( self._inputFile )
        pfamOutput = self.hmmscanOutputProcess.readHmmOutput(file)
        self.assertEqual(["Polinton-1_DY:classII:Polinton_4", "2742", "2766", "rve", "50", "78", "2.4e+03", "-3.3"], pfamOutput.get(0))
        self.assertEqual(["Polinton-1_DY:classII:Polinton_4", "2951", "3101", "rve", "4", "168", "6.7e-30", "103.4"], pfamOutput.get(1))
        self.assertEqual(["Polinton-1_DY:classII:Polinton_4", "3198", "3228", "Chromo", "4", "51", "8.5e-06", "24.7"], pfamOutput.get(2))
        self.assertEqual(["Polinton-1_DY:classII:Polinton_4", "2117", "2125", "GARS_A", "196", "204", "11", "2.5"], pfamOutput.get(3))
        file.close()
        
    def test_readHmmerscanOutput_empty_file(self):
        file = open( "./datas/OutputhmmscanEmpty", "w" )
        file.close()
        file = open( "./datas/OutputhmmscanEmpty")
        pfamOutput = self.hmmscanOutputProcess.readHmmOutput(file)
        file.close()
        self.assertEqual(None, pfamOutput)
        os.system("rm ./datas/OutputhmmscanEmpty")
        
    def testParseHmmscanOutput2Align(self):
        self.hmmscanOutputProcess.readHmmOutputsAndWriteAlignFile(self._inputFileScan2, self._outputFile)
        self.assertTrue(FileUtils.isRessourceExists(self._outputFile))
        self.assertTrue(FileUtils.are2FilesIdentical(self._outputFileScan2, self._outputFile))
        os.system("rm " + self._outputFile)
        
    def test_parseHmmscanOutput2Align_empty_file(self):
        file = open("./datas/dummy_hmmpfam_output", "w")
        file.close()
        self._inputFile = "./datas/dummy_hmmpfam_output"
        self.hmmscanOutputProcess.readHmmOutputsAndWriteAlignFile( self._inputFile, self._outputFile )
        self.assertTrue(FileUtils.isEmpty(self._outputFile))
        os.system("rm " + self._inputFile)
        os.system("rm " + self._outputFile)
        
    def test_parseHmmscanOutput2Align_file_not_exists(self):
        self._inputFile = "./datas/dummy_hmmpfam_output"
        self.hmmscanOutputProcess.readHmmOutputsAndWriteAlignFile(self._inputFile, self._outputFile )
        self.assertFalse(FileUtils.isRessourceExists(self._outputFile))
        
if __name__ == "__main__":                 
    unittest.main()