import os
import unittest
from commons.pyRepetUnit.hmmer.hmmOutput.HmmOutput import HmmOutput
from commons.pyRepetUnit.hmmer.hmmOutput.HmmOutputProcessing import HmmOutputProcessing
from commons.pyRepetUnit.hmmer.hmmOutput.HmmpfamOutputProcessing import HmmpfamOutputProcessing
from commons.pyRepetUnit.hmmer.hmmOutput.HmmscanOutputProcessing import HmmscanOutputProcessing
from commons.core.utils.FileUtils import FileUtils

class TestHmmOutputProcessing(unittest.TestCase):
    
    def setUp(self):
        self.hmmOutput = HmmOutputProcessing()
        self._inputFile = "./datas/test_hmmpfam_output" 
        self._outputFile =  "./datas/dummyoutput.align" 
        self._inputFileScan2 = "./datas/hmmscanOutput"
        self._outputFileScan2 = "./datas/hmmscanOutput.align"       
        
    def test_writeHmmOutputToAlignFile(self):
        output = open("./datas/output.align", "w")
        output.write("SAR:satellite:satellite_5\t3\t9\tDUF751\t5\t11\t5.4\t5.4\t0\n")
        output.write("SAR:satellite:satellite_5\t17\t23\tDUF751\t5\t11\t5.1\t5.5\t0\n")
        output.write("SAR:satellite:satellite_5\t3\t21\tClenterotox\t173\t191\t0.66\t7.4\t0\n")
        output.close()
        pfamOutput = HmmOutput()
        pfamOutput.append(["SAR:satellite:satellite_5", "3", "9", "DUF751", "5", "11", "5.4", "5.4"])
        pfamOutput.append(["SAR:satellite:satellite_5", "17", "23", "DUF751", "5", "11", "5.1", "5.5"])
        pfamOutput.append(["SAR:satellite:satellite_5", "3", "21", "Clenterotox", "173", "191", "0.66", "7.4"])
        fout = open("./datas/outputGen.align", "w")
        self.hmmOutput.writeHmmOutputToAlignFile(pfamOutput, fout)
        fout.close()
        self.assertTrue(FileUtils.are2FilesIdentical("./datas/output.align", "./datas/outputGen.align"))
        os.remove("./datas/output.align")
        os.remove("./datas/outputGen.align")
        
if __name__ == "__main__":                 
    unittest.main()