import unittest
import os
import ConfigParser
import shutil
from commons.pyRepetUnit.hmmer.profilsSearchInTEClassifier.ProfilesSearch import ProfilesSearch

class Test_ProfilesSearch(unittest.TestCase):


    def setUp(self):
        self._section = 'detect_features'
        self._option1 = 'TE_HMM_profiles'
        self._option2 = 'TE_HMMER_evalue'
        self._config = ConfigParser.ConfigParser()
        self._config.add_section(self._section)
        self._config.set(self._section, self._option1, './datas/hmmbank_test')        
        self._config.set(self._section, self._option2, '10')
        self._iProfilesSearch = ProfilesSearch()
        self._launch1 = 'First Command\n'
        self._launch2 = '\nSecond Command\n'
        self._cDir = '.'
        self._profileBank = self._config.get(self._section, self._option1)
        self._bank = os.path.basename(self._profileBank)
        shutil.copy(self._profileBank, self._cDir + "/" + self._bank)

    def tearDown(self):
        os.remove(self._cDir + "/" + self._bank)

    def test_prepareProfilesBank(self):
        hmmpressLaunched = False
        self._iProfilesSearch.prepareProfilesBank( self._launch1, self._launch2, self._config, self._cDir )
        if ( os.path.exists(self._cDir + "/" + self._bank + ".h3m") \
            and os.path.exists(self._cDir + "/" + self._bank + ".h3i") \
            and os.path.exists(self._cDir + "/" + self._bank + ".h3f") \
            and os.path.exists(self._cDir + "/" + self._bank + ".h3p")) :
            hmmpressLaunched = True
            os.remove(self._cDir + "/" + self._bank + ".h3m")
            os.remove(self._cDir + "/" + self._bank + ".h3i")
            os.remove(self._cDir + "/" + self._bank + ".h3f")
            os.remove(self._cDir + "/" + self._bank + ".h3p")
        self.assertTrue(hmmpressLaunched)

    def test_detectHmmProfiles(self):
        inputFileName = ' FileName'
        dirTemp = 'Tempory directory'
        eValueMax = self._config.get(self._section, self._option2)
        
        expCommand = self._launch1 
        expCommand += os.environ["REPET_PATH"] + "/bin/translateAfastaFileInAllFrameAndReplaceStopsByX_script.py"
        expCommand += " -i %s" % ( inputFileName ) + " -o %s_translated" % ( inputFileName )
        expCommand += self._launch2
        
        expCommand += self._launch1
        expCommand += "hmmscan "
        expCommand += " -o %s_tr.hmmScanOut" % ( inputFileName )
        expCommand += " --domtblout %s_tr.hmmScanOutTab" % ( inputFileName )
        expCommand += " --noali "
        expCommand += "-E " + eValueMax
        expCommand += " --cpu 1" 
        expCommand += " " + self._cDir + "/" + self._bank + " " + "%s_translated" % ( inputFileName )
        
        expCommand += self._launch2
        
        expCommand += "if os.path.exists( \"%s_translated\" ):\n" % ( inputFileName )
        expCommand += "\tos.remove( \"%s_translated\" )\n" % ( inputFileName )

        expCommand += self._launch1
        expCommand += os.environ["REPET_PATH"] + "/bin/HmmOutput2alignAndTransformCoordInNtAndFilterScores_script.py"
        expCommand += " -i %s_tr.hmmScanOutTab" % ( inputFileName )
        expCommand += " -o %s_profiles_%s.align" % ( inputFileName, self._bank )
        expCommand += " -T %s" % ( inputFileName )
        expCommand += " -p hmmscan"
        expCommand += " -c"
        expCommand += self._launch2

        expCommand += self._launch1
        expCommand += os.environ["REPET_PATH"] + "/bin/matcher"
        expCommand += " -m %s_profiles_%s.align" % ( inputFileName, self._bank )
        expCommand += " -j"
        expCommand += " -E 10"
        expCommand += " -L 0"
        expCommand += " -v 1"
        expCommand += self._launch2

        expCommand += "if not os.path.exists( \"%s/%s_profiles_%s.align.clean_match.path\" ):\n" % ( self._cDir, inputFileName, self._bank )
        expCommand += "\tos.system( \"mv %s_profiles_%s.align.clean_match.path %s\" )\n" % ( inputFileName, self._bank, self._cDir )
        expCommand += "if not os.path.exists( \"%s/%s_profiles_%s.align.clean_match.param\" ):\n" % ( self._cDir, inputFileName, self._bank )
        expCommand += "\tos.system( \"mv %s_profiles_%s.align.clean_match.param %s\" )\n" % ( inputFileName, self._bank, self._cDir )
        expCommand += "if os.path.exists( \"%s_profiles_%s.align\" ):\n" % ( inputFileName, self._bank )
        expCommand += "\tos.remove( \"%s_profiles_%s.align\" )\n" % ( inputFileName, self._bank )
        expCommand += "if os.path.exists( \"%s_profiles_%s.align.clean_match.map\" ):\n" % ( inputFileName, self._bank )
        expCommand += "\tos.remove( \"%s_profiles_%s.align.clean_match.map\" )\n" % ( inputFileName, self._bank )
        expCommand += "if os.path.exists( \"%s_hmmScanOut\" ):\n" % ( inputFileName )
        expCommand += "\tos.remove( \"%s_hmmScanOut\" )\n" % ( inputFileName )

        if dirTemp != dir:
            expCommand += "if os.path.exists( \"%s\" ):\n" % ( self._bank )
            expCommand += "\tos.remove( \"%s\" )\n" % ( self._bank )
        
        obsCommand = self._iProfilesSearch.detectHmmProfiles( inputFileName, self._launch1, self._launch2, self._cDir, dirTemp, self._config )
        self.assertEquals(expCommand, obsCommand)
        

        
if __name__ == "__main__":
    unittest.main()