import os
import unittest
from commons.pyRepetUnit.fastaTranslation.allFrames.TranslateInAllFramesAndReplaceStopByX import TranslateInAllFramesAndReplaceStopByX
from commons.core.seq.Bioseq import Bioseq
from commons.core.utils.FileUtils import FileUtils

class Test_TranslateInAllFramesAndReplaceStopByX(unittest.TestCase):
    
    def setUp(self):
        self.bioseq = Bioseq()
        self.preProcess = TranslateInAllFramesAndReplaceStopByX()
        self._inputFile = "./datas/dummy.fa" 
        self._outputFile =  "./datas/dummyoutput.fa" 
        
        
    def testRun(self):
        self.preProcess.setInputFile(self._inputFile)
        self.preProcess.setOutputFile(self._outputFile)
        # real fasta file
        f = open(self._inputFile, "w")
        f.write(">header1 description\n")
        f.write("TGTGGCTTCTAGTTGATCAGTTTATGATCACAATGATTTCACGTAGGTGTCTCGTGGCTC\n")
        f.write("CGACTAATCAACAATATAATGCGAGTAGAGCTTGA\n")
        f.write(">header2\n")
        f.write("TGTGGCTTCTAGTTGATCAGTTTATGATCACAATGATTTCACGTAGGTGTCTCGTGGCTA\n")
        f.write("CGACTAATCAACAATATAATGCGAGTAGAGCTTGA")
        f.close()
        # expected fasta translated file
        f = open("./datas/expectedTranslated.fa", "w")
        f.write(">header1_1 description\n")
        f.write("CGFXLISLXSQXFHVGVSWLRLINNIMRVEL\n")
        f.write(">header1_2 description\n")
        f.write("VASSXSVYDHNDFTXVSRGSDXSTIXCEXSL\n")
        f.write(">header1_3 description\n")
        f.write("WLLVDQFMITMISRRCLVAPTNQQYNASRAX\n")
        f.write(">header1_4 description\n")
        f.write("SSSTRIILLISRSHETPTXNHCDHKLINXKP\n")
        f.write(">header1_5 description\n")
        f.write("QALLALYCXLVGATRHLREIIVIINXSTRSH\n")
        f.write(">header1_6 description\n")
        f.write("KLYSHYIVDXSEPRDTYVKSLXSXTDQLEAT\n")
        f.write(">header2_1\n")
        f.write("CGFXLISLXSQXFHVGVSWLRLINNIMRVEL\n")
        f.write(">header2_2\n")
        f.write("VASSXSVYDHNDFTXVSRGYDXSTIXCEXSL\n")
        f.write(">header2_3\n")
        f.write("WLLVDQFMITMISRRCLVATTNQQYNASRAX\n")
        f.write(">header2_4\n")
        f.write("SSSTRIILLISRSHETPTXNHCDHKLINXKP\n")
        f.write(">header2_5\n")
        f.write("QALLALYCXLVVATRHLREIIVIINXSTRSH\n")
        f.write(">header2_6\n")
        f.write("KLYSHYIVDXSXPRDTYVKSLXSXTDQLEAT\n")
        f.close()
        self.preProcess.run()
        self.assertTrue(FileUtils.are2FilesIdentical("./datas/expectedTranslated.fa", self._outputFile))
        os.system("rm " + self._inputFile)
        os.system("rm " + self._outputFile)
        os.system("rm ./datas/expectedTranslated.fa")
        # empty fasta file
        #self.preProcess.translateAfastaFileInAllFrame()
        #self.assertFalse(FileUtils.isRessourceExists(self._outputFile))

if __name__ == "__main__":                 
    unittest.main()