#! /usr/bin/env python
"""
Plot the data from the data files
"""

import os
import re
from optparse import OptionParser
from parsing.fastaParser import *
from parsing.fastqParser import *
from misc.rPlotter import *
from misc.progress import *
from misc import utils


if __name__ == "__main__":
  
  # parse command line
  description = "Get Read Distribution: Plot the number of identical reads and give the most represented. [Category: Sequences]"

  parser = OptionParser(description = description)
  parser.add_option("-i", "--input",        dest="inputFileName",     action="store",                        type="string", help="input file sequence [compulsory] [format: file in sequence format given by -f]")
  parser.add_option("-f", "--format",       dest="format",            action="store",                        type="string", help="format of the file [compulsory] [format: sequence file format]")
  parser.add_option("-n", "--number",       dest="number",            action="store",      default=None,     type="int",    help="keep the best n  [format: int]")
  parser.add_option("-p", "--percent",      dest="percent",           action="store",      default=None,     type="float",  help="keep the best n\% [format: float]")
  parser.add_option("-o", "--output",       dest="outputFileName",    action="store",                        type="string", help="output file [compulsory] [format: output file in PNG format]")
  parser.add_option("-x", "--xMax",         dest="xMax",              action="store",      default=None,     type="int",    help="maximum value on the x-axis to plot  [format: int]")
  parser.add_option("-l", "--log",          dest="log",               action="store",      default="",       type="string", help="use log on x, y, or x and x axis [format: string] [default: ]")
  parser.add_option("-v", "--verbosity",    dest="verbosity",         action="store",      default=1,        type="int",    help="trace level [format: int]")
  (options, args) = parser.parse_args()

  if options.format == "fasta":
    parser = FastaParser(options.inputFileName, options.verbosity)
  elif options.format == "fastq":
    parser = FastqParser(options.inputFileName, options.verbosity)
  else:
    sys.exit("Do not understand '%s' file format." % (options.format))

  progress  = Progress(parser.getNbSequences(), "Reading %s" % (options.inputFileName), options.verbosity)
  sequences = {}
  for sequence in parser.getIterator():
    sequence = sequence.sequence
    if sequence not in sequences:
      sequences[sequence] = 1
    else:
      sequences[sequence] += 1
    progress.inc()
  progress.done()

  values = sequences.values()
  values.sort()
  if options.percent != None:
    threshold = values[int(float(options.percent) / 100 * len(values))]
  elif options.number != None:
    threshold = values[-options.number]
  else:
    threshold = 0

  outputFileName = "%s.txt" % (options.outputFileName)
  handle         = open(outputFileName, "w")
  progress       = Progress(parser.getNbSequences(), "Writing into %s" % (outputFileName), options.verbosity)
  for sequence, value in sequences.iteritems():
    if value >= threshold:
      handle.write("%s\t%d\n" % (sequence, value))
    progress.inc()
  progress.done()
  handle.close()

  line     = {}
  progress = Progress(len(values), "Preparing plot", options.verbosity)
  for value in values:
    if value not in line:
      line[value] = 1
    else:
      line[value] += 1
    progress.inc()
  progress.done()

  plot = RPlotter("%s.png" % (options.outputFileName), options.verbosity)
  plot.setFill(0)
  plot.setLog(options.log)
  plot.setMaximumX(options.xMax)
  plot.setXLabel("# occurrences")
  plot.setYLabel("# reads")
  plot.addLine(line)
  plot.plot()

  print "%d/%.2f/%.1f/%d occurrences" % (utils.getMinAvgMedMax(line))


