#ifndef INPUT_FILE_PARSER_HPP
#define INPUT_FILE_PARSER_HPP

#include <string>
#include <vector>
#include <map>
#include "genomicInterval.hpp"

typedef vector<Interval *> IntervalsType;
typedef map<string, IntervalsType *> SortedIntervalsTypes;
typedef map<string, unsigned int> CounterType;
typedef pair<Interval *, unsigned int> NumberIntervalType;

static bool operator<(const NumberIntervalType &i1, const NumberIntervalType &i2) {
    if (i1.first < i2.first) return true;
    return ((i1.first == i2.first) && (i1.second < i2.second));
}

class InputFileParser {

    private:
        SortedIntervalsTypes sortedIntervals;
        CounterType counter;

        void addToList(GenomicInterval &genomicInterval);
        void writeTmpFile(string &chromosome);
        void syncFiles();
        string getTmpName(const string &chromosome, unsigned int i);
        string getTmpName(const string &chromosome);
        void merge();
        void merge(const string &chromosome, ofstream &outputFile);

    public:
        string inputFileName;
        string outputFileName;
        string outputFilePrefix;

        InputFileParser(string inputFileName, string outputFileName);

        void parse(); 

};

#endif

