import unittest
from SMART.Java.Python.structure.Interval import Interval
from SMART.Java.Python.structure.SubMapping import SubMapping
from SMART.Java.Python.structure.Mapping import Mapping

class Test_Mapping(unittest.TestCase):

    def test__getTranscript(self):
        queryInterval1 = Interval()
        queryInterval1.setName("read1_1")
        queryInterval1.setStart(1)
        queryInterval1.setEnd(10)
        queryInterval1.setDirection(1)

        targetInterval1 = Interval()
        targetInterval1.setChromosome("chr1")
        targetInterval1.setStart(100)
        targetInterval1.setEnd(110)
        targetInterval1.setDirection(1)

        subMapping1 = SubMapping()
        subMapping1.setQueryInterval(queryInterval1)
        subMapping1.setTargetInterval(targetInterval1)

        queryInterval2 = Interval()
        queryInterval2.setName("read1_2")
        queryInterval2.setStart(11)
        queryInterval2.setEnd(20)
        queryInterval2.setDirection(1)

        targetInterval2 = Interval()
        targetInterval2.setChromosome("chr1")
        targetInterval2.setStart(200)
        targetInterval2.setEnd(210)
        targetInterval2.setDirection(1)

        subMapping2 = SubMapping()
        subMapping2.setQueryInterval(queryInterval2)
        subMapping2.setTargetInterval(targetInterval2)

        mapping = Mapping()
        mapping.addSubMapping(subMapping1)
        mapping.addSubMapping(subMapping2)

        transcript = mapping.getTranscript()
        self.assertEqual(transcript.getStart(),      100)
        self.assertEqual(transcript.getEnd(),        210)
        self.assertEqual(transcript.getChromosome(), "chr1")
        exons = transcript.getExons()
        self.assertEqual(len(exons), 2)
        exon1, exon2 = exons
        self.assertEqual(exon1.getStart(), 100)
        self.assertEqual(exon1.getEnd(),   110)
        self.assertEqual(exon2.getStart(), 200)
        self.assertEqual(exon2.getEnd(),   210)


if __name__ == '__main__':
    unittest.main()
