import unittest
import os, os.path
from SMART.Java.Python.misc import Utils

SMART_PATH = os.environ["REPET_PATH"] + "/SMART"

class Test_F_compareOverlapping(unittest.TestCase):

    def setUp(self):
        self._inputFileQuery     = "inputFileTest1.bed"
        self._inputFileReference = "inputFileTest2.bed"
        self._inputFileName3     = "inputFileTest3.bed"
        self._expOutputFileName  = "expOutput.gff3"  
        self._outputFileName     = "output.gff3"   
        self._writeInputFileQuery()
        self._writeInputFileRefence()
        self._writeInputFile3()  
        
    def tearDown(self):
        for fileName in (self._inputFileQuery, self._inputFileReference, self._inputFileName3, self._expOutputFileName, self._outputFileName):
            if os.path.exists(fileName):
                os.remove(fileName)

    def test_runAsScript_withoutOption(self):
        self._writeOutputFile_withoutOption(self._expOutputFileName) 
        os.system("python %s/Java/Python/CompareOverlapping.py -i %s -f bed -j %s -g bed -o %s -v 0" % (SMART_PATH, self._inputFileQuery, self._inputFileReference, self._outputFileName))
        self.assertTrue(Utils.diff(self._expOutputFileName, self._outputFileName))
            
    def test_runAsScript_optionNFirstNucleotide(self):
        self._writeOutputFile_NFirstNucleotide(self._expOutputFileName) 
        os.system("python %s/Java/Python/CompareOverlapping.py -i %s -f bed -j %s -g bed -o %s -S 200 -s 200 -v 0" % (SMART_PATH, self._inputFileQuery, self._inputFileReference, self._outputFileName))
        self.assertTrue(Utils.diff(self._expOutputFileName, self._outputFileName))

    def test_runAsScript_optionNLastNucleotide(self):
        self._writeOutputFile_NLastNucleotide(self._expOutputFileName) 
        os.system("python %s/Java/Python/CompareOverlapping.py -i %s -f bed -j %s -g bed -o %s -U 200 -u 200 -v 0" % (SMART_PATH, self._inputFileQuery, self._inputFileReference, self._outputFileName))
        self.assertTrue(Utils.diff(self._expOutputFileName, self._outputFileName))

    def test_runAsScript_option_5PrimeExtension(self):
        self._writeOutputFile_5PrimeExtension(self._expOutputFileName) 
        os.system("python %s/Java/Python/CompareOverlapping.py -i %s -f bed -j %s -g bed -o %s -E 110 -e 110 -v 0" % (SMART_PATH, self._inputFileQuery, self._inputFileReference, self._outputFileName))
        self.assertTrue(Utils.diff(self._expOutputFileName, self._outputFileName))

    def test_runAsScript_option_3PrimeExtension(self):
        self._writeOutputFile_3PrimeExtension(self._expOutputFileName) 
        os.system("python %s/Java/Python/CompareOverlapping.py -i %s -f bed -j %s -g bed -o %s -N 110 -n 110 -v 0" % (SMART_PATH, self._inputFileQuery, self._inputFileReference, self._outputFileName))
        self.assertTrue(Utils.diff(self._expOutputFileName, self._outputFileName))
        
    def test_runAsScript_colinear(self):
        self._writeOutputFile_colinear(self._expOutputFileName) 
        os.system("python %s/Java/Python/CompareOverlapping.py -i %s -f bed -j %s -g bed -o %s -c -v 0" % (SMART_PATH, self._inputFileQuery, self._inputFileReference, self._outputFileName))
        self.assertTrue(Utils.diff(self._expOutputFileName, self._outputFileName))

    def test_runAsScript_antisense(self):
        self._writeOutputFile_antisense(self._expOutputFileName) 
        os.system("python %s/Java/Python/CompareOverlapping.py -i %s -f bed -j %s -g bed -o %s -a -v 0" % (SMART_PATH, self._inputFileQuery, self._inputFileReference, self._outputFileName))
        self.assertTrue(Utils.diff(self._expOutputFileName, self._outputFileName))

    def test_runAsScript_minOverlap(self):
        self._writeOutputFile_minOverlap(self._expOutputFileName) 
        os.system("python %s/Java/Python/CompareOverlapping.py -i %s -f bed -j %s -g bed -o %s -m 51 -v 0" % (SMART_PATH, self._inputFileQuery, self._inputFileName3, self._outputFileName))
        self.assertTrue(Utils.diff(self._expOutputFileName, self._outputFileName))

    def test_runAsScript_pcOverlap(self):
        self._writeOutputFile_pcOverlap(self._expOutputFileName) 
        os.system("python %s/Java/Python/CompareOverlapping.py -i %s -f bed -j %s -g bed -o %s -p 60 -v 0" % (SMART_PATH, self._inputFileQuery, self._inputFileName3, self._outputFileName))
        self.assertTrue(Utils.diff(self._expOutputFileName, self._outputFileName))

    def test_runAsScript_included(self):
        self._writeOutputFile_included(self._expOutputFileName) 
        os.system("python %s/Java/Python/CompareOverlapping.py -i %s -f bed -j %s -g bed -o %s -k -v 0" % (SMART_PATH, self._inputFileQuery, self._inputFileReference, self._outputFileName))
        self.assertTrue(Utils.diff(self._expOutputFileName, self._outputFileName))
            
    def test_runAsScript_including(self):
        self._writeOutputFile_including(self._expOutputFileName) 
        os.system("python %s/Java/Python/CompareOverlapping.py -i %s -f bed -j %s -g bed -o %s -K -v 0" % (SMART_PATH, self._inputFileQuery, self._inputFileReference, self._outputFileName))
        self.assertTrue(Utils.diff(self._expOutputFileName, self._outputFileName))
            
    def test_runAsScript_includeNotOverlap(self):
        self._writeOutputFile_includeNotOverlap(self._expOutputFileName) 
        os.system("python %s/Java/Python/CompareOverlapping.py -i %s -f bed -j %s -g bed -o %s -O -v 0" % (SMART_PATH, self._inputFileQuery, self._inputFileReference, self._outputFileName))
        self.assertTrue(Utils.diff(self._expOutputFileName, self._outputFileName))

    def test_runAsScript_exclude(self):
        self._writeOutputFile_exclude(self._expOutputFileName) 
        os.system("python %s/Java/Python/CompareOverlapping.py -i %s -f bed -j %s -g bed -o %s -x -v 0" % (SMART_PATH, self._inputFileQuery, self._inputFileReference, self._outputFileName))
        self.assertTrue(Utils.diff(self._expOutputFileName, self._outputFileName))
              
    def _writeInputFileQuery(self):
        f = open(self._inputFileQuery, "w")
        f.write("arm_X\t1000\t2000\ttest1.1\t1000\t+\t1000\t2000\t0\t1\t1000,\t0,\n")
        f.write("arm_X\t1000\t2000\ttest1.2\t1000\t-\t1000\t2000\t0\t1\t1000,\t0,\n")
        f.write("arm_X\t100\t200\ttest1.3\t1000\t+\t100\t200\t0\t1\t100,\t0,\n")
        f.write("arm_X\t100\t3200\ttest1.4\t1000\t+\t100\t3200\t0\t1\t3100,\t0,\n")
        f.close()
        
    def _writeInputFileRefence(self):
        f = open(self._inputFileReference, "w")
        f.write("arm_X\t1000\t2000\ttest2.1\t1000\t+\t1000\t2000\t0\t1\t1000,\t0,\n")
        f.close()
        
    def _writeInputFile3(self):
        f = open(self._inputFileName3, "w")
        f.write("arm_X\t1000\t2000\ttest2.1\t1000\t+\t1000\t2000\t0\t1\t1000,\t0,\n")
        f.write("arm_X\t250\t350\ttest2.2\t1000\t+\t250\t350\t0\t1\t100,\t0,\n")
        f.write("arm_X\t150\t250\ttest2.3\t1000\t+\t150\t250\t0\t1\t100,\t0,\n")
        f.close()
        
    def _writeOutputFile_withoutOption(self, outputFileName):
        f = open(outputFileName, "w")
        f.write("arm_X\tS-MART\ttranscript\t100\t3199\t.\t+\t.\toverlapWith=test2.1;nbOverlaps=1.000000;ID=test1.4;Name=test1.4\n")
        f.write("arm_X\tS-MART\ttranscript\t1000\t1999\t.\t+\t.\toverlapWith=test2.1;nbOverlaps=1.000000;ID=test1.1;Name=test1.1\n")
        f.write("arm_X\tS-MART\ttranscript\t1000\t1999\t.\t-\t.\toverlapWith=test2.1;nbOverlaps=1.000000;ID=test1.2;Name=test1.2\n")
        f.close()

    def _writeOutputFile_NFirstNucleotide(self, outputFileName):
        f = open(outputFileName, "w")
        f.write("arm_X\tS-MART\ttranscript\t1000\t1199\t.\t+\t.\toverlapWith=test2.1;nbOverlaps=1.000000;ID=test1.1;Name=test1.1\n")
        f.close()  
        
    def _writeOutputFile_NLastNucleotide(self, outputFileName):
        f = open(outputFileName, "w")
        f.write("arm_X\tS-MART\ttranscript\t1800\t1999\t.\t+\t.\toverlapWith=test2.1;nbOverlaps=1.000000;ID=test1.1;Name=test1.1\n")
        f.close()              

    def _writeOutputFile_5PrimeExtension(self, outputFileName):
        f = open(outputFileName, "w")
        f.write("arm_X\tS-MART\ttranscript\t0\t3199\t.\t+\t.\toverlapWith=test2.1;nbOverlaps=1.000000;ID=test1.4;Name=test1.4\n")
        f.write("arm_X\tS-MART\ttranscript\t890\t1999\t.\t+\t.\toverlapWith=test2.1;nbOverlaps=1.000000;ID=test1.1;Name=test1.1\n")
        f.write("arm_X\tS-MART\ttranscript\t1000\t2109\t.\t-\t.\toverlapWith=test2.1;nbOverlaps=1.000000;ID=test1.2;Name=test1.2\n")
        f.close()
        
    def _writeOutputFile_3PrimeExtension(self, outputFileName):
        f = open(outputFileName, "w")
        f.write("arm_X\tS-MART\ttranscript\t100\t3309\t.\t+\t.\toverlapWith=test2.1;nbOverlaps=1.000000;ID=test1.4;Name=test1.4\n")
        f.write("arm_X\tS-MART\ttranscript\t1000\t2109\t.\t+\t.\toverlapWith=test2.1;nbOverlaps=1.000000;ID=test1.1;Name=test1.1\n")
        f.write("arm_X\tS-MART\ttranscript\t890\t1999\t.\t-\t.\toverlapWith=test2.1;nbOverlaps=1.000000;ID=test1.2;Name=test1.2\n")
        f.close()   
        
    def _writeOutputFile_colinear(self, outputFileName):
        f = open(outputFileName, "w")
        f.write("arm_X\tS-MART\ttranscript\t100\t3199\t.\t+\t.\toverlapWith=test2.1;nbOverlaps=1.000000;ID=test1.4;Name=test1.4\n")
        f.write("arm_X\tS-MART\ttranscript\t1000\t1999\t.\t+\t.\toverlapWith=test2.1;nbOverlaps=1.000000;ID=test1.1;Name=test1.1\n")
        f.close()    
        
    def _writeOutputFile_antisense(self, outputFileName):
        f = open(outputFileName, "w")
        f.write("arm_X\tS-MART\ttranscript\t1000\t1999\t.\t-\t.\toverlapWith=test2.1;nbOverlaps=1.000000;ID=test1.2;Name=test1.2\n")
        f.close()  
           
    def _writeOutputFile_minOverlap(self, outputFileName):
        f = open(outputFileName, "w")
        f.write("arm_X\tS-MART\ttranscript\t100\t3199\t.\t+\t.\toverlapWith=test2.3,test2.2,test2.1;nbOverlaps=3.000000;ID=test1.4;Name=test1.4\n")
        f.write("arm_X\tS-MART\ttranscript\t1000\t1999\t.\t+\t.\toverlapWith=test2.1;nbOverlaps=1.000000;ID=test1.1;Name=test1.1\n")
        f.write("arm_X\tS-MART\ttranscript\t1000\t1999\t.\t-\t.\toverlapWith=test2.1;nbOverlaps=1.000000;ID=test1.2;Name=test1.2\n")
        f.close() 
        
    def _writeOutputFile_pcOverlap(self, outputFileName):
        f = open(outputFileName, "w")
        f.write("arm_X\tS-MART\ttranscript\t1000\t1999\t.\t+\t.\toverlapWith=test2.1;nbOverlaps=1.000000;ID=test1.1;Name=test1.1\n")
        f.write("arm_X\tS-MART\ttranscript\t1000\t1999\t.\t-\t.\toverlapWith=test2.1;nbOverlaps=1.000000;ID=test1.2;Name=test1.2\n")
        f.close() 
        
    def _writeOutputFile_includeNotOverlap(self, outputFileName):
        f = open(outputFileName, "w")
        f.write("arm_X\tS-MART\ttranscript\t100\t3199\t.\t+\t.\toverlapWith=test2.1;nbOverlaps=1.000000;ID=test1.4;Name=test1.4\n")
        f.write("arm_X\tS-MART\ttranscript\t100\t199\t.\t+\t.\tnbOverlaps=0;ID=test1.3;Name=test1.3\n")
        f.write("arm_X\tS-MART\ttranscript\t1000\t1999\t.\t+\t.\toverlapWith=test2.1;nbOverlaps=1.000000;ID=test1.1;Name=test1.1\n")
        f.write("arm_X\tS-MART\ttranscript\t1000\t1999\t.\t-\t.\toverlapWith=test2.1;nbOverlaps=1.000000;ID=test1.2;Name=test1.2\n")
        f.close()

    def _writeOutputFile_exclude(self, outputFileName):
        f = open(outputFileName, "w")
        f.write("arm_X\tS-MART\ttranscript\t100\t199\t.\t+\t.\tID=test1.3;Name=test1.3\n")
        f.close()
        
    def _writeOutputFile_included(self, outputFileName):
        f = open(outputFileName, "w")
        f.write("arm_X\tS-MART\ttranscript\t1000\t1999\t.\t+\t.\toverlapWith=test2.1;nbOverlaps=1.000000;ID=test1.1;Name=test1.1\n")
        f.write("arm_X\tS-MART\ttranscript\t1000\t1999\t.\t-\t.\toverlapWith=test2.1;nbOverlaps=1.000000;ID=test1.2;Name=test1.2\n")
        f.close()

    def _writeOutputFile_including(self, outputFileName):
        f = open(outputFileName, "w")
        f.write("arm_X\tS-MART\ttranscript\t100\t3199\t.\t+\t.\toverlapWith=test2.1;nbOverlaps=1.000000;ID=test1.4;Name=test1.4\n")
        f.write("arm_X\tS-MART\ttranscript\t1000\t1999\t.\t+\t.\toverlapWith=test2.1;nbOverlaps=1.000000;ID=test1.1;Name=test1.1\n")
        f.write("arm_X\tS-MART\ttranscript\t1000\t1999\t.\t-\t.\toverlapWith=test2.1;nbOverlaps=1.000000;ID=test1.2;Name=test1.2\n")
        f.close()

    def _writeInputFileQuery_withExon(self):
        f = open(self._inputFileQuery, "w")
        f.write("arm_X\t1000\t2000\ttest1.1\t1000\t+\t1000\t2000\t0\t1\t1000,\t0,\n")
        f.write("arm_X\t1000\t2000\ttest1.2\t1000\t-\t1000\t2000\t0\t1\t1000,\t0,\n")
        f.write("arm_X\t100\t200\ttest1.3\t1000\t+\t100\t200\t0\t1\t100,\t0,\n")
        f.write("arm_X\t100\t3200\ttest1.4\t1000\t+\t100\t3200\t0\t2\t100,100,\t0,3000,\n")
        f.close()
        
if __name__ == "__main__":
    unittest.main()
