#ifndef INTERVAL_HPP
#define INTERVAL_HPP
#include <iostream>
#include <fstream>
using namespace std;

typedef unsigned int Position;

class Interval {

    public:
        Position start;
        Position end;

        Interval(unsigned int start = 0, unsigned int end = 0): start(start), end(end) { }

        Interval(Interval &i): start(i.start), end(i.end) { }

        bool include(Interval &interval) {
            return ((start <= interval.start) && (end >= interval.end));
        }

        void writeBinary(ofstream &stream) {
            stream.write(reinterpret_cast<const char*>(&start), sizeof(Position));
            stream.write(reinterpret_cast<const char*>(&end),   sizeof(Position));
        }

        bool parseBinary(ifstream &stream) {
            stream.read(reinterpret_cast<char*>(&start), sizeof(Position));
            stream.read(reinterpret_cast<char*>(&end),   sizeof(Position));
            return (! stream.eof());
        }

        friend bool operator==(const Interval &i1, const Interval &i2) {
            return ((i1.start == i2.start) && (i1.start == i2.end));
        }

        friend bool operator<(const Interval &i1, const Interval &i2) {
            if (i1.start < i2.start) return true;
            return ((i1.start == i2.start) && (i1.end > i2.end));
        }

};

#endif
