import unittest
import os
from SMART.Java.Python.getExons import GetExons
from commons.core.parsing.GffParser import GffParser

class Test_F_GetExons(unittest.TestCase):

    def setUp(self):
        self._inputFileName = "inputFileTest.bed"
        self._writeInputFile()
        self._outputFileName = "output.gff3"
        
    def tearDown(self):
        os.remove(self._inputFileName)
        os.remove(self._outputFileName)

    def test_run_simple(self):
        ge = GetExons(0)
        ge.setInputFile(self._inputFileName, "bed")
        ge.setOutputFile(self._outputFileName)
        ge.run()
        parser = GffParser(self._outputFileName, 0)
        self.assertEqual(parser.getNbTranscripts(), 5)
        for cpt, transcript in enumerate(parser.getIterator()):
            self.assertEqual(transcript.getChromosome(), "arm_X")
            self.assertEqual(transcript.getDirection(), 1)
            self.assertEqual(transcript.getNbExons(), 1)
            if cpt == 0:
                self.assertEqual(transcript.getStart(), 10000001)
                self.assertEqual(transcript.getEnd(),   10000100)
            elif cpt == 1:
                self.assertEqual(transcript.getStart(), 10000201)
                self.assertEqual(transcript.getEnd(),   10000300)
            elif cpt == 2:
                self.assertEqual(transcript.getStart(), 10000401)
                self.assertEqual(transcript.getEnd(),   10000500)
            elif cpt == 3:
                self.assertEqual(transcript.getStart(), 10000601)
                self.assertEqual(transcript.getEnd(),   10000700)
            elif cpt == 4:
                self.assertEqual(transcript.getStart(), 10000801)
                self.assertEqual(transcript.getEnd(),   10000900)

    def test_run_firstExon(self):
        ge = GetExons(0)
        ge.setInputFile(self._inputFileName, "bed")
        ge.setOutputFile(self._outputFileName)
        ge.setSelection("1")
        ge.run()
        parser = GffParser(self._outputFileName, 0)
        self.assertEqual(parser.getNbTranscripts(), 1)
        for cpt, transcript in enumerate(parser.getIterator()):
            self.assertEqual(transcript.getChromosome(), "arm_X")
            self.assertEqual(transcript.getDirection(), 1)
            self.assertEqual(transcript.getNbExons(), 1)
            self.assertEqual(transcript.getStart(), 10000001)
            self.assertEqual(transcript.getEnd(),   10000100)

    def test_run_lastExon(self):
        ge = GetExons(0)
        ge.setInputFile(self._inputFileName, "bed")
        ge.setOutputFile(self._outputFileName)
        ge.setSelection("-1")
        ge.run()
        parser = GffParser(self._outputFileName, 0)
        self.assertEqual(parser.getNbTranscripts(), 1)
        for cpt, transcript in enumerate(parser.getIterator()):
            self.assertEqual(transcript.getChromosome(), "arm_X")
            self.assertEqual(transcript.getDirection(), 1)
            self.assertEqual(transcript.getNbExons(), 1)
            self.assertEqual(transcript.getStart(), 10000801)
            self.assertEqual(transcript.getEnd(),   10000900)

    def test_run_first_lastExon(self):
        ge = GetExons(0)
        ge.setInputFile(self._inputFileName, "bed")
        ge.setOutputFile(self._outputFileName)
        ge.setSelection("1,-1")
        ge.run()
        parser = GffParser(self._outputFileName, 0)
        self.assertEqual(parser.getNbTranscripts(), 2)
        for cpt, transcript in enumerate(parser.getIterator()):
            self.assertEqual(transcript.getChromosome(), "arm_X")
            self.assertEqual(transcript.getDirection(), 1)
            self.assertEqual(transcript.getNbExons(), 1)
            if cpt == 0:
                self.assertEqual(transcript.getStart(), 10000001)
                self.assertEqual(transcript.getEnd(),   10000100)
            elif cpt == 1:
                self.assertEqual(transcript.getStart(), 10000801)
                self.assertEqual(transcript.getEnd(),   10000900)

    def test_run_interval(self):
        ge = GetExons(0)
        ge.setInputFile(self._inputFileName, "bed")
        ge.setOutputFile(self._outputFileName)
        ge.setSelection("2..3")
        ge.run()
        parser = GffParser(self._outputFileName, 0)
        self.assertEqual(parser.getNbTranscripts(), 2)
        for cpt, transcript in enumerate(parser.getIterator()):
            self.assertEqual(transcript.getChromosome(), "arm_X")
            self.assertEqual(transcript.getDirection(), 1)
            self.assertEqual(transcript.getNbExons(), 1)
            if cpt == 0:
                self.assertEqual(transcript.getStart(), 10000201)
                self.assertEqual(transcript.getEnd(),   10000300)
            elif cpt == 1:
                self.assertEqual(transcript.getStart(), 10000401)
                self.assertEqual(transcript.getEnd(),   10000500)

    def test_run_interval_element(self):
        ge = GetExons(0)
        ge.setInputFile(self._inputFileName, "bed")
        ge.setOutputFile(self._outputFileName)
        ge.setSelection("2..3,-1")
        ge.run()
        parser = GffParser(self._outputFileName, 0)
        self.assertEqual(parser.getNbTranscripts(), 3)
        for cpt, transcript in enumerate(parser.getIterator()):
            self.assertEqual(transcript.getChromosome(), "arm_X")
            self.assertEqual(transcript.getDirection(), 1)
            self.assertEqual(transcript.getNbExons(), 1)
            if cpt == 0:
                self.assertEqual(transcript.getStart(), 10000201)
                self.assertEqual(transcript.getEnd(),   10000300)
            elif cpt == 1:
                self.assertEqual(transcript.getStart(), 10000401)
                self.assertEqual(transcript.getEnd(),   10000500)
            elif cpt == 2:
                self.assertEqual(transcript.getStart(), 10000801)
                self.assertEqual(transcript.getEnd(),   10000900)



    def _writeInputFile(self):
        f = open(self._inputFileName, "w")
        f.write("arm_X\t10000001\t10000900\ttest1.1\t100\t+\t10000100\t10000200\t0\t5\t100,100,100,100,100,\t0,200,400,600,800,\n")
        f.close()
        
                

if __name__ == "__main__":
    unittest.main()

