#! /usr/bin/env python
"""Clusterize a set of transcripts"""

import os
from optparse import OptionParser
from writer.transcriptWriter import *
from mySql.mySqlConnection import *
from structure.transcriptContainer import *
from structure.transcriptListsComparator import *
from mySql.mySqlConnection import *
from misc.rPlotter import *
from misc.progress import *


if __name__ == "__main__":
  
  # parse command line
  description = "Clusterize: clusterize the data which overlap. [Category: Merge]"

  parser = OptionParser(description = description)
  parser.add_option("-i", "--input",          dest="inputFileName",  action="store",                     type="string", help="input file [compulsory] [format: file in transcript format given by -f]")
  parser.add_option("-f", "--format",         dest="format",         action="store",                     type="string", help="format of file [format: transcript file format]")
  parser.add_option("-o", "--output",         dest="outputFileName", action="store",                     type="string", help="output file [compulsory] [format: output file in GFF3 format]")
  parser.add_option("-c", "--colinear",       dest="colinear",       action="store_true", default=False,                help="merge colinear transcripts only [format: bool] [default: false]")
  parser.add_option("-d", "--distance",       dest="distance",       action="store",      default=0,     type="int",    help="max. distance between two transcripts to be merged [format: int] [default: 0]")
  parser.add_option("-v", "--verbosity",      dest="verbosity",      action="store",      default=1,     type="int",    help="trace level [format: int] [default: 1]")
  parser.add_option("-l", "--log",            dest="log",            action="store_true", default=False,                help="write a log file [format: bool] [default: false]")
  (options, args) = parser.parse_args()

  logHandle = None
  if options.log:
    logHandle = open("%s.log" % (options.outputFileName), "w")
  
  transcriptListComparator = TranscriptListsComparator(logHandle, options.verbosity)
  transcriptListComparator.getColinearOnly(options.colinear)
  transcriptContainer = TranscriptContainer(options.inputFileName, options.format)
  transcriptListComparator.setMaxDistance(options.distance)
  transcriptListComparator.aggregate(True)
  transcriptListComparator.computeOdds(True)
  transcriptListComparator.setInputTranscriptContainer(transcriptListComparator.QUERY, transcriptContainer)
  transcriptListComparator.compareTranscriptListSelfMerge()
  outputTranscriptContainer = transcriptListComparator.getOutputTranscripts()
  
  if options.outputFileName != None:
    writer = TranscriptWriter(options.outputFileName, "gff3", options.verbosity)
    writer.setContainer(outputTranscriptContainer)
    writer.write()
      
  if options.log:
    logHandle.close()
