from structure.transcriptList import *


class TranscriptListIterator(object):
  """A class that iterates on a list of transcript"""

  def __init__(self, transcriptList, verbosity = 0):
    self.transcriptList    = transcriptList
    self.verbosity         = verbosity
    self.chromosomes       = self.transcriptList.transcripts.keys()
    self.currentChromosome = 0
    self.currentTranscript = -1


  def __iter__(self):
    return self
  
  
  def next(self):
    self.currentTranscript += 1
    while True:
      if self.currentChromosome >= len(self.transcriptList.transcripts):
        raise StopIteration
      elif self.currentTranscript >= len(self.transcriptList.transcripts[self.chromosomes[self.currentChromosome]]):
        self.currentTranscript  = 0
        self.currentChromosome += 1
      elif self.transcriptList.transcripts[self.chromosomes[self.currentChromosome]][self.currentTranscript] == None:
        self.currentTranscript += 1
      else:
        return self.transcriptList.transcripts[self.chromosomes[self.currentChromosome]][self.currentTranscript]
      
