from commons.core.parsing.PslParser import PslParser
import unittest, os


class Test_PslParser(unittest.TestCase):

    def test_forward(self):
        fileName = "tmpFile.psl"
        handle   = open(fileName, "w")
        handle.write("psLayout version 3\n\nmatch\tmis-\trep.\tN's\tQ gap\tQ gap\tT gap\tT gap\tstrand\tQ\tQ\tQ\tQ\T\tT\tT\tT\tblock\tblockSizes\tqStarts\ttStarts\nmatch\tmatch\tcount\tbases\tcount\tbases\tname\tsize\tstart\tend\tname\tsize\tstart\tend\tcount\n---------------------------------------------------------------------------------------------------------------------------------------------------------------\n158\t0\t0\t0\t0\t0\t1\t158\t+\ttest\t158\t0\t158\tchr1\t1501\t237\t553\t2\t79,79,\t0,79,\t237,474,\n")
        handle.close()

        parser = PslParser(fileName, 0)
        self.assertEquals(parser.getNbMappings(), 1)
        for mapping in parser.getIterator():
            transcript = mapping.getTranscript()
            self.assertEquals(transcript.getName(), "test")
            self.assertEquals(transcript.getChromosome(), "chr1")
            self.assertEquals(transcript.getDirection(), 1)
            self.assertEquals(transcript.getStart(), 238)
            self.assertEquals(transcript.getEnd(),   553)
            self.assertEquals(transcript.getNbExons(), 2)
            for i, exon in enumerate(transcript.getExons()):
                if i == 0:
                    self.assertEquals(exon.getStart(), 238)
                    self.assertEquals(exon.getEnd(),   316)
                elif i == 1:
                    self.assertEquals(exon.getStart(), 475)
                    self.assertEquals(exon.getEnd(),   553)
        os.remove(fileName)
        
        
    def test_backward(self):
        fileName = "tmpFile.psl"
        handle   = open(fileName, "w")
        handle.write("psLayout version 3\n\nmatch\tmis-\trep.\tN's\tQ gap\tQ gap\tT gap\tT gap\tstrand\tQ\tQ\tQ\tQ\tT\tT\tT\tT\tblock\tblockSizes\tqStarts\ttStarts\nmatch\tmatch\tcount\tbases\tcount\tbases\tname\tsize\tstart\tend\tname\tsize\tstart\tend\tcount\n---------------------------------------------------------------------------------------------------------------------------------------------------------------\n158\t0\t0\t0\t0\t0\t1\t158\t-\ttest\t158\t0\t158\tchr1\t1501\t237\t553\t2\t79,79,\t0,79,\t237,474,\n")

        handle.close()

        parser = PslParser(fileName, 0)
        self.assertEquals(parser.getNbMappings(), 1)
        for mapping in parser.getIterator():
            transcript = mapping.getTranscript()
            self.assertEquals(transcript.getName(), "test")
            self.assertEquals(transcript.getChromosome(), "chr1")
            self.assertEquals(transcript.getDirection(), -1)
            self.assertEquals(transcript.getStart(), 238)
            self.assertEquals(transcript.getEnd(),   553)
            self.assertEquals(transcript.getNbExons(), 2)
            for i, exon in enumerate(transcript.getExons()):
                if i == 1:
                    self.assertEquals(exon.getStart(), 238)
                    self.assertEquals(exon.getEnd(),   316)
                elif i == 0:
                    self.assertEquals(exon.getStart(), 475)
                    self.assertEquals(exon.getEnd(),   553)
        os.remove(fileName)


    def test_query_forward_target_forward(self):
        fileName = "tmpFile.psl"
        handle   = open(fileName, "w")
        handle.write("psLayout version 3\n\nmatch\tmis-\trep.\tN's\tQ gap\tQ gap\tT gap\tT gap\tstrand\tQ\tQ\tQ\tQ\tT\tT\tT\tT\tblock\tblockSizes\tqStarts\ttStarts\nmatch\tmatch\tcount\tbases\tcount\tbases\tname\tsize\tstart\tend\tname\tsize\tstart\tend\tcount\n---------------------------------------------------------------------------------------------------------------------------------------------------------------\n241\t0\t0\t0\t0\t0\t1\t60\t++\tseq1\t255\t9\t250\tref\t2262\t59\t360\t2\t121,120,\t9,130,\t59,240,\n")
        handle.close()

        parser = PslParser(fileName, 0)
        self.assertEquals(parser.getNbMappings(), 1)
        for mapping in parser.getIterator():
            transcript = mapping.getTranscript()
            self.assertEquals(transcript.getName(), "seq1")
            self.assertEquals(transcript.getChromosome(), "ref")
            self.assertEquals(transcript.getDirection(), 1)
            self.assertEquals(transcript.getStart(), 60)
            self.assertEquals(transcript.getEnd(),   360)
            self.assertEquals(transcript.getNbExons(), 2)
            for i, exon in enumerate(transcript.getExons()):
                if i == 0:
                    self.assertEquals(exon.getStart(), 60)
                    self.assertEquals(exon.getEnd(),   180)
                elif i == 1:
                    self.assertEquals(exon.getStart(), 241)
                    self.assertEquals(exon.getEnd(),   360)
        os.remove(fileName)

    def test_query_backward_target_forward(self):
        fileName = "tmpFile.psl"
        handle   = open(fileName, "w")
        handle.write("psLayout version 3\n\nmatch\tmis-\trep.\tN's\tQ gap\tQ gap\tT gap\tT gap\tstrand\tQ\tQ\tQ\tQ\tT\tT\tT\tT\tblock\tblockSizes\tqStarts\ttStarts\nmatch\tmatch\tcount\tbases\tcount\tbases\tname\tsize\tstart\tend\tname\tsize\tstart\tend\tcount\n---------------------------------------------------------------------------------------------------------------------------------------------------------------\n241\t0\t0\t0\t0\t0\t1\t60\t-+\tseq2\t255\t5\t246\tref\t2262\t59\t360\t2\t121,120,\t9,130,\t59,240,\n")
        handle.close()

        parser = PslParser(fileName, 0)
        self.assertEquals(parser.getNbMappings(), 1)
        for mapping in parser.getIterator():
            transcript = mapping.getTranscript()
            self.assertEquals(transcript.getName(), "seq2")
            self.assertEquals(transcript.getChromosome(), "ref")
            self.assertEquals(transcript.getDirection(), -1)
            self.assertEquals(transcript.getStart(), 60)
            self.assertEquals(transcript.getEnd(),   360)
            self.assertEquals(transcript.getNbExons(), 2)
            for i, exon in enumerate(transcript.getExons()):
                if i == 1:
                    self.assertEquals(exon.getStart(), 60)
                    self.assertEquals(exon.getEnd(),   180)
                elif i == 0:
                    self.assertEquals(exon.getStart(), 241)
                    self.assertEquals(exon.getEnd(),   360)
        os.remove(fileName)

    def test_query_backward_target_backward(self):
        fileName = "tmpFile.psl"
        handle   = open(fileName, "w")
        handle.write("psLayout version 3\n\nmatch\tmis-\trep.\tN's\tQ gap\tQ gap\tT gap\tT gap\tstrand\tQ\tQ\tQ\tQ\tT\tT\tT\tT\tblock\tblockSizes\tqStarts\ttStarts\nmatch\tmatch\tcount\tbases\tcount\tbases\tname\tsize\tstart\tend\tname\tsize\tstart\tend\tcount\n---------------------------------------------------------------------------------------------------------------------------------------------------------------\n241\t1\t0\t0\t0\t0\t1\t60\t--\tseq1\t255\t8\t250\tref\t2262\t58\t360\t2\t120,122,\t5,125,\t1902,2082,\n")
        handle.close()

        parser = PslParser(fileName, 0)
        self.assertEquals(parser.getNbMappings(), 1)
        for mapping in parser.getIterator():
            transcript = mapping.getTranscript()
            self.assertEquals(transcript.getName(), "seq1")
            self.assertEquals(transcript.getChromosome(), "ref")
            self.assertEquals(transcript.getDirection(), 1)
            self.assertEquals(transcript.getStart(), 59)
            self.assertEquals(transcript.getEnd(),   360)
            self.assertEquals(transcript.getNbExons(), 2)
            for i, exon in enumerate(transcript.getExons()):
                if i == 0:
                    self.assertEquals(exon.getStart(), 59)
                    self.assertEquals(exon.getEnd(),   180)
                elif i == 1:
                    self.assertEquals(exon.getStart(), 241)
                    self.assertEquals(exon.getEnd(),   360)
        os.remove(fileName)


    def test_query_forward_target_backward(self):
        fileName = "tmpFile.psl"
        handle   = open(fileName, "w")
        handle.write("psLayout version 3\n\nmatch\tmis-\trep.\tN's\tQ gap\tQ gap\tT gap\tT gap\tstrand\tQ\tQ\tQ\tQ\tT\tT\tT\tT\tblock\tblockSizes\tqStarts\ttStarts\nmatch\tmatch\tcount\tbases\tcount\tbases\tname\tsize\tstart\tend\tname\tsize\tstart\tend\tcount\n---------------------------------------------------------------------------------------------------------------------------------------------------------------\n241\t1\t0\t0\t0\t0\t1\t60\t+-\tseq2\t255\t5\t247\tref\t2262\t58\t360\t2\t120,122,\t5,125,\t1902,2082,\n")
        handle.close()

        parser = PslParser(fileName, 0)
        self.assertEquals(parser.getNbMappings(), 1)
        for mapping in parser.getIterator():
            transcript = mapping.getTranscript()
            self.assertEquals(transcript.getName(), "seq2")
            self.assertEquals(transcript.getChromosome(), "ref")
            self.assertEquals(transcript.getDirection(), -1)
            self.assertEquals(transcript.getStart(), 59)
            self.assertEquals(transcript.getEnd(),   360)
            self.assertEquals(transcript.getNbExons(), 2)
            for i, exon in enumerate(transcript.getExons()):
                if i == 1:
                    self.assertEquals(exon.getStart(), 59)
                    self.assertEquals(exon.getEnd(),   180)
                elif i == 0:
                    self.assertEquals(exon.getStart(), 241)
                    self.assertEquals(exon.getEnd(),   360)
        os.remove(fileName)


if __name__ == "__main__":
    unittest.main()


