from commons.core.launcher.WriteScript import WriteScript
from commons.core.sql.Job import Job
from commons.core.sql.DbFactory import DbFactory
from commons.core.sql.TableJobAdaptatorFactory import TableJobAdaptatorFactory
import sys
import stat
import os
import time
import unittest
import glob

class Test_F_TableJobAdaptator(unittest.TestCase):

    def setUp(self):
        self._jobTableName = "dummyJobTable"
        self._iJA = TableJobAdaptatorFactory.createJobInstance()

    def tearDown(self):
        pass
    
    def test_submitJob(self):
        job1 = self._createJobInstance("job1")
        self._createLauncherFile(job1, self._iJA)
        job2 = self._createJobInstance("job2")
        self._createLauncherFile(job2, self._iJA)
        job3 = self._createJobInstance("job3")
        self._createLauncherFile(job3, self._iJA)
        
        self._iJA.submitJob( job1, maxNbWaitingJobs=3, checkInterval=5, verbose=0 )
        self._iJA.submitJob( job2, maxNbWaitingJobs=3, checkInterval=5, verbose=0 )
        self._iJA.submitJob( job3, maxNbWaitingJobs=3, checkInterval=5, verbose=0 )

        time.sleep(120)
        
        expErrorFilePrefix1 = job1.jobname + ".e" 
        expOutputFilePrefix1 = job1.jobname + ".o"
        expErrorFilePrefix2 = job2.jobname + ".e" 
        expOutputFilePrefix2 = job2.jobname + ".o"
        expErrorFilePrefix3 = job3.jobname + ".e" 
        expOutputFilePrefix3 = job3.jobname + ".o"
        
        lErrorFiles1 = glob.glob(expErrorFilePrefix1 + "*")
        lOutputFiles1 = glob.glob(expOutputFilePrefix1 + "*")
        lErrorFiles2 = glob.glob(expErrorFilePrefix2 + "*")
        lOutputFiles2 = glob.glob(expOutputFilePrefix2 + "*")
        lErrorFiles3 = glob.glob(expErrorFilePrefix3 + "*")
        lOutputFiles3 = glob.glob(expOutputFilePrefix3 + "*")
        
        isLErrorFileNotEmpty1 = (len(lErrorFiles1) != 0) 
        isLOutputFileNotEmpty1 = (len(lOutputFiles1) != 0)
        isLErrorFileNotEmpty2 = (len(lErrorFiles2) != 0) 
        isLOutputFileNotEmpty2 = (len(lOutputFiles2) != 0)
        isLErrorFileNotEmpty3 = (len(lErrorFiles3) != 0) 
        isLOutputFileNotEmpty3 = (len(lOutputFiles3) != 0)
        
        os.system("rm launcherFileTest*.py *.e* *.o*")
        self.assertTrue(isLErrorFileNotEmpty1 and isLOutputFileNotEmpty1)
        self.assertTrue(isLErrorFileNotEmpty2 and isLOutputFileNotEmpty2)
        self.assertTrue(isLErrorFileNotEmpty3 and isLOutputFileNotEmpty3)
    
    def test_submit_and_waitJobGroup(self):
        iJob = self._createJobInstance("test")
        self._createLauncherFile(iJob, self._iJA)
        
        self._iJA.submitJob( iJob, maxNbWaitingJobs=3, checkInterval=5, verbose=0 )
        self._iJA.waitJobGroup(iJob.groupid, 0, 2)
        
        expErrorFilePrefix1 = iJob.jobname + ".e" 
        expOutputFilePrefix1 = iJob.jobname + ".o"
        
        lErrorFiles1 = glob.glob(expErrorFilePrefix1 + "*")
        lOutputFiles1 = glob.glob(expOutputFilePrefix1 + "*")
        
        isLErrorFileExist = (len(lErrorFiles1) != 0) 
        isLOutputFileExist = (len(lOutputFiles1) != 0)
        os.system("rm launcherFileTest*.py *.e* *.o*")
        self.assertTrue(isLErrorFileExist and isLOutputFileExist)

    def _createJobInstance(self, name):
        lResources = []
        if os.environ.get("HOSTNAME") == "compute-2-46.local":
            lResources.append("test=TRUE")
        return Job(0, name, "test", "", "log = os.system(\"date;sleep 5;date\")", "%s/launcherFileTest_%s.py" % (os.getcwd(), name), lResources=lResources)

    def _createLauncherFile(self, iJob, iJA):
        iWriteScript = WriteScript(iJob, iJA, os.getcwd(), os.getcwd(), False, True)
        iWriteScript.run(iJob.command, "", iJob.launcher)
        os.chmod(iJob.launcher, stat.S_IRWXU+stat.S_IRWXG+stat.S_IRWXO)
        
if __name__ == "__main__":
    unittest.main()
