#!/usr/bin/env python
##@file
# Abstract class to launch a program.

import getopt
import sys
import os
import pyRepet.launcher.AbstractProgramLauncher

class AbstractProgramLauncher( pyRepet.launcher.AbstractProgramLauncher.AbstractProgramLauncher ):  #( IProgramLauncher )
    
    def getHelpAsString( self ):
        """
        Return the generic help as a string.
        """
        string = ""
        string += "usage: %s.py [options]" % ( type(self).__name__ )
        string += "\ngeneric options:"
        string += "\n     -h: this help"
        string += "\n     -i: name of the input file (format='%s')" % ( self.getFormatInputFile() )
        string += "\n     -c: clean"
        string += "\n     -v: verbosity level (default=0/1)"
        return string
    
    def setAttributesFromCmdLine( self, o, a="" ):
        """
        Set a generic attribute from the command-line arguments.
        """
        if o == "-h":
            print self.getHelpAsString()
            sys.exit(0)
        elif o == "-i":
            self.setInputFile( a )
        elif o == "-c":
            self.setClean()
        elif o == "-v":
            self.setVerbosityLevel( a )
    
    def checkAttributesFromCmdLine( self ):
        """
        Set the attributes from the command-line arguments.
        """
        try:
            opts, args = getopt.getopt( sys.argv[1:], "%s" % (self.getCmdLineOptions()) )
        except getopt.GetoptError, err:
            print str(err);
            print self.getHelpAsString()
            sys.exit(1)
        for o, a in opts:
            self.setAttributesFromCmdLine( o, a )
    
    def getCmdLineOptions(self):
        return self._cmdLineGenericOptions
            
    def check( self ):
        """
        Check the generic attributes before running the program.
        """
        self._checkProgramName()
        self.checkInput()

    def checkInput(self):
        if self.getInputFile() == "":
            string = "ERROR: missing input file"
            print string
            print self.getHelpAsString()
            sys.exit(1)
        
        if not os.path.exists(self.getInputFile()):
            string = "ERROR: input file '%s' doesn't exist" % (self.getInputFile())
            print string
            print self.getHelpAsString()
            sys.exit(1)
