
## Interface for AbstractClusterLauncher 
#
class IClusterLauncher(object):
    
    ## Constructor.
    #
    def __init__( self ):
        pass
    
    ## Useful commands before running the program (check, open database connector...).
    #
    def start(self):
        pass
    
    ## Useful commands after the program was run (clean, close database connector...).
    #
    def end(self):
        pass
    
    ## Launch jobs in parallel on each file in the query directory.
    #
    def run(self):
        pass
    
    ## Initialize the job (jobname, command, launcher).
    #
    def initializeJob(self, fileName, count):
        pass
    
    ## Return all the job commands as a string.
    #
    def getJobCommandsAsString(self, fileName, jobName, minFreeGigaInTmpDir=1):
        pass
    
    ## Return the generic help as a string.
    #
    def getGenericHelpAsString(self):
        pass
    
    ## Check the generic attributes before running the program.
    #
    def checkGenericAttributes(self):
        pass
    
    ## Check the specific attributes of each program launcher.
    #
    def checkSpecificAttributes(self):
        pass
    
    ## Check that all required programs are in the user's PATH.
    #
    def checkProgramAvailability(self):
        pass
    
    ## Return the command-line to launch in each job. Specified in each wrapper.
    #
    def getProgramCommandLineAsString(self):
        pass
    
    ## Return the list of files to keep at the end of each job. Specified in each wrapper.
    #
    def getListFilesToKeep(self):
        pass
    
    ## Return the list of files to remove at the end of each job. Specified in each wrapper.
    #
    def getListFilesToRemove(self):
        pass
    
    ## Return the name of the job file as a string.
    #
    def getJobFileNameAsString(self, count):
        pass
    
    ## Return the command to update the job status in the table.
    #
    def getCmdUpdateJobStatusAsString(self, newStatus):
        pass
    
    ## Return the launching command as a string. Launch the wrapper, retrieve its exit status, update status if error.
    #
    def getCmdToLaunchWrapper(self, fileName, genericCmd, exeWrapper):
        pass
    
    ## Return the commands to keep the output files.
    #
    def getCmdToKeepFiles( self, fileName, lFilesToKeep ):
        pass
    
    ## Return the commands to remove the temporary files.
    #
    def getCmdToRemoveFiles( self, fileName, lFilesToRemove ):
        pass
    
    ## Remove all job files.
    #   
    def removeAllJobFiles( self ):
        pass
            
    ## Remove all job stdout.
    # 
    def removeAllJobStdouts( self ):
        pass
            
    ## Remove all job stderr.
    #
    def removeAllJobStderrs( self ):
        pass
            
    ## Process the output file if necessary.
    #        
    def processOutputFile( self, tmpFile, outFile ):
        pass
        
    ## Concatenate output files from all jobs.
    #    
    def catOutputFiles( self ):
        pass
    
    ## Return the specific help as a string.
    #
    def getSpecificHelpAsString( self ):
        pass
    
    ## Return the help as a string.
    #
    def getHelpAsString( self ):
        pass
    
    ##Set a generic attribute from the command-line arguments.
    #
    def setAGenericAttributeFromCmdLine( self, o, a="" ):
        pass
            
    ## Set the specific attributes from the command-line arguments.
    #       
    def setASpecificAttributeFromCmdLine( self, o, a="" ):
        pass
        
    ## Set the attributes from the command-line arguments.
    #
    def setAttributesFromCmdLine( self ):
        pass
            
    ## 
    #        
    def setInputDirectory( self, arg ):
        pass

    ## 
    #
    def setQueueName( self, arg ):
        pass
    
    ##
    #    
    def setGroupIdentifier( self, arg ):
        pass
    
    ##
    #
    def setInputFileSuffix( self, arg ):
        pass
    
    ##
    #   
    def setAcronym( self, arg ):
        pass
    
    ##
    #    
    def setConfigFile( self, arg ):
        pass
    
    ##
    #        
    def setCurrentDirectory( self ):
        pass
    
    ##
    #    
    def setTemporaryDirectory( self, arg ):
        pass
    
    ##
    #
    def setJobTableName( self, arg ):
        pass
    
    ##
    #
    def setCatOutputFiles( self ):
        pass
    
    ##
    #
    def setClean( self ):
        pass
    
    ##
    #
    def setVerbosityLevel( self, arg ):
        pass
    
    ##
    #
    def setExecutableWrapper( self, arg ):
        pass
    
    ## Set the wrapper and program command-lines of the program launcher. Append the program launcher to 'self.lPrgLaunchers'.
    #
    def setSingleProgramLauncher( self ):
        pass
        
    ##
    #
    def getInputDirectory( self ):
        pass
    
    ##
    #    
    def getQueueName( self ):
        pass
    
    ##
    #    
    def getGroupIdentifier( self ):
        pass
    
    ##
    #
    def getInputFileSuffix( self ):
        pass
    
    ##
    #
    def getAcronym( self ):
        pass
    
    ##
    #    
    def getConfigFile( self ):
        pass
    
    ##
    #
    def getCurrentDirectory( self ):
        pass
    
    ##
    #   
    def getTemporaryDirectory( self ):
        pass
    
    ##
    # 
    def getJobTableName( self ):
        pass
    
    ##
    #
    def getCatOutputFiles( self ):
        pass
    
    ##
    #
    def getClean( self ):
        pass
    
    ##
    #
    def getVerbosityLevel( self ):
        pass
    
    ##
    #
    def getWrapperName( self ):
        pass
    
    ##
    #
    def getProgramName( self ):
        pass
    
    ##
    #
    def getPatternToConcatenate( self ):
        pass
    