'''
Created on 18 mai 2009

@author: choede
'''
import unittest
import commons.pyRepetUnit.profilesDB.CompleteAProfilesDBFromAFileWithProfilesNamesOrAccNumber


class TestCompleteProfilesDBFromProfilesNameListOrAccNumber(unittest.TestCase):


    def setUp(self):
        self._fileProfilesList = "./datas/ListPfamProfilsInRepbase.txt"
        self._filePfamList = "./datas/ListpfamAccNumber.txt"
        self._profilesDB = "./datas/profilesDBTest.hmm"
        self.CompleteProfilesDB = commons.pyRepetUnit.profilesDB.CompleteAProfilesDBFromAFileWithProfilesNamesOrAccNumber.CompleteAProfilesDBFromAFileWithProfilesNamesOrAccNumber()
        self.CompleteProfilesDB.setProfilesDBFile ( self._profilesDB )
        self._expectedList = ["zf-CCHC", "InvE", "Chromo", "TLV_coat"]
        self._expectedList2 = ["PF00075", "PF00424", "PF00469"]
        self._expectedGetzCmd = "getz -e \'[pfamhmm-Id:\"zf-CCHC*\"] | [pfamhmm-Id:\"InvE*\"] | [pfamhmm-Id:\"Chromo*\"] | [pfamhmm-Id:\"TLV_coat*\"]\'"
        self._expectedGetzCmd2 = "getz -e \'[pfamhmm-AccNumber:\"PF00075\"] | [pfamhmm-AccNumber:\"PF00424\"] | [pfamhmm-AccNumber:\"PF00469\"]\'"
        
        
    def tearDown(self):
        pass


    def testListNotExistingProfiles(self):
        #with name
        self.CompleteProfilesDB.setProfilesToAdd ( self._fileProfilesList )
        profilesNotInDBList = self.CompleteProfilesDB.generateNotExistingProfilesList( )
        i = 0
        if profilesNotInDBList != []:
            for profil in profilesNotInDBList:
                self.assertEquals(profil, self._expectedList[i])
                i = i + 1
        #with pfam accession number
        self.CompleteProfilesDB.setProfilesToAdd ( self._filePfamList )
        self.CompleteProfilesDB.setPfamAccNumberKeys ()
        profilesNotInDBList = self.CompleteProfilesDB.generateNotExistingProfilesList( )
        i = 0
        if profilesNotInDBList != []:
            for profil in profilesNotInDBList:
                self.assertEquals(profil, self._expectedList2[i])
                i = i + 1
    
    def testCreateGetzCommand(self):  
        getzCmd = self.CompleteProfilesDB.generateGetzCmdProfilesList( self._expectedList )
        # pour le moment je cherche dans les fs ou les ls si je ne veux que les fs specifier type = fs ce sera surement le cas a terme
        self.assertEqual (getzCmd, self._expectedGetzCmd)
        
    def testCmdToCompleteProfileDBFromList(self): 
        #names list
        self.CompleteProfilesDB.setProfilesToAdd ( self._fileProfilesList ) 
        getzCmd = self.CompleteProfilesDB.CmdToCompleteProfileDB()
        self.assertEqual (getzCmd, self._expectedGetzCmd)  
        #pfam accession Number list
        self.CompleteProfilesDB.setPfamAccNumberKeys ()
        self.CompleteProfilesDB.setProfilesToAdd ( self._filePfamList ) 
        getzCmd = self.CompleteProfilesDB.CmdToCompleteProfileDB()
        self.assertEqual (getzCmd, self._expectedGetzCmd2)
        
    

if __name__ == "__main__":
    unittest.main()