import unittest
import time
import os
from commons.core.sql.TableMapAdaptator import TableMapAdaptator
from commons.core.coord.Map import Map
#from commons.pyRepetUnit.profilesDB.tests.InsertProfilesMapFileInDBTestRessources import InsertProfilesMapFileInDBTestRessources
from commons.pyRepetUnit.profilesDB.InsertProfilesMapFileInDB import InsertProfilesMapFileInDB
from commons.core.sql.DbMySql import DbMySql


class TestInsertProfilesMapFileInDB(unittest.TestCase):
    
    def setUp(self):
        self._inputFileName = "./datas/profiles.map"
        self._createProfilesMapFile()
#        self._host = InsertProfilesMapFileInDBTestRessources.REPET_DB_HOST
#        self._user = InsertProfilesMapFileInDBTestRessources.REPET_DB_USER
#        self._passwd = InsertProfilesMapFileInDBTestRessources.REPET_DB_PW
#        self._dbname = InsertProfilesMapFileInDBTestRessources.REPET_DB_NAME
#        self._db = DbMySql( self._user, self._host, self._passwd, self._dbname )
        self._db = DbMySql( os.environ["REPET_USER"],
                            os.environ["REPET_HOST"],
                            os.environ["REPET_PW"],
                            os.environ["REPET_DB"] )
        self._uniqId = "%s_%s" % ( time.strftime("%Y%m%d%H%M%S") , os.getpid() )
        self._table = "dummyMapTable_%s" % ( self._uniqId )

    def tearDown(self):
        os.remove(self._inputFileName)
        self._deleteDBtables()
        self._db.close()

    def testInsertProfilesMapFileInDB(self):
        resultFromFileMapUtils = self._readMapResultsFromFileAndFillList()
        InsertProfilesMapFileInDBinstance = InsertProfilesMapFileInDB(self._inputFileName, self._table,  self._db)
        InsertProfilesMapFileInDBinstance.createAndLoadTable()
        resultFromTableMapUtils = self._readMapResultsFromTableAndFillList() 
        self.assertEquals(resultFromFileMapUtils, resultFromTableMapUtils)
    
    def _createProfilesMapFile(self):
        f = open(self._inputFileName, "w")
        f.write("rrm\t\t1\t77\n")
        f.write("fn3\tFibronectin type III domain\t1\t84\n")
        f.write("pkinase\tProtein kinase domain\t1\t294\n")
        f.close()
        
    def _readMapResultsFromTableAndFillList(self):
        tableMapAdaptatorInstance = TableMapAdaptator (self._db, self._table)
        return tableMapAdaptatorInstance.getListOfAllMaps()

    def _readMapResultsFromFileAndFillList(self):
       mapInstance = Map()
       lMap = []
       f = open( self._inputFileName , "r")
       while mapInstance.read( f ):
            lMap.append (mapInstance)
            mapInstance = Map()
       f.close()
       return lMap
   
    def _deleteDBtables(self):
        self._db.dropTable(self._table)
        
if __name__ == "__main__":
    unittest.main()
