import unittest
import os
from commons.pyRepetUnit.profilesDB.Profiles import Profiles
from commons.pyRepetUnit.profilesDB.ProfilesDatabankUtils import ProfilesDatabankUtils


class TestProfilesDatabankUtils( unittest.TestCase ):
    
    def setUp( self ):
        self.profilesDBUtils = ProfilesDatabankUtils()        
        
        
    def test_read_emptyFile( self ):
        file = open( "pfamDBEmpty", "w" )
        file.close()
        pfamDB2 = self.profilesDBUtils.read( "pfamDBEmpty" )
        self.assertEquals( None, pfamDB2 )
        os.remove( "pfamDBEmpty" )
        
        
    def test_read( self ):
        f = open("dummy.hmm", "w")
        f.write("HMMER2.0  [2.3.2]\n")
        f.write("NAME  fn3\n")
        f.write("ACC   PF00041\n")
        f.write("DESC  Fibronectin type III domain\n")
        f.write("LENG  84\n")
        f.write("ALPH  Amino\n")
        f.write("RF    no\n")
        f.write("CS    yes\n")
        f.write("MAP   yes\n")
        f.write("COM   hmmbuild -A myhmms fn3.sto\n")
        f.write("COM   hmmcalibrate myhmms\n")
        f.write("NSEQ  108\n")
        f.write("DATE  Thu Jan  8 17:50:26 2009\n")
        f.write("CKSUM 6130\n")
        f.write("GA    7.8 -1.0\n")
        f.write("TC    7.9 0.1\n")
        f.write("XT      -8455     -4  -1000  -1000  -8455     -4  -8455     -4 \n")
        f.write("NULT      -4  -8455\n")
        f.write("NULE     595  -1558     85    338   -294    453  -1158    197    249    902  -1085   -142    -21   -313     45    531    201    384  -1998   -644 \n")
        f.write("EVD   -45.973442   0.237545\n")
        f.write("HMM        A      C      D      E      F      G      H      I      K      L      M      N      P      Q      R      S      T      V      W      Y    \n")
        f.write("         m->m   m->i   m->d   i->m   i->i   d->m   d->d   b->m   m->e\n")
        f.write("COM   hmmcalibrate myhmms\n")
        f.write("          -13      *  -6756\n")
        f.write("     1  -1698  -4236  -5399   -847  -4220  -2885  -1259   -930  -2438    406  -3428  -4768   3631  -1835  -4773  -1187  -1331   -120  -4666  -1510     1\n")
        f.write("     -   -150   -501    232     46   -382    399    104   -628    211   -461   -722    274    395     44     95    358    118   -368   -296   -251 \n")
        f.write("     C   -144  -3400 -12951    -19  -6286   -701  -1378    -13      * \n")
        f.write("//\n")
        f.write("HMMER2.0  [2.3.2]\n")
        f.write("NAME  truc\n")
        f.write("ACC   PF00041\n")
        f.write("LENG  123\n")
        f.write("ALPH  Amino\n")
        f.write("RF    no\n")
        f.write("CS    yes\n")
        f.write("MAP   yes\n")
        f.write("COM   hmmbuild -A myhmms fn3.sto\n")
        f.write("COM   hmmcalibrate myhmms\n")
        f.write("NSEQ  108\n")
        f.write("DATE  Thu Jan  8 17:50:26 2009\n")
        f.write("CKSUM 6130\n")
        f.write("GA    7.8 -1.0\n")
        f.write("TC    7.9 0.1\n")
        f.write("XT      -8455     -4  -1000  -1000  -8455     -4  -8455     -4 \n")
        f.write("NULT      -4  -8455\n")
        f.write("NULE     595  -1558     85    338   -294    453  -1158    197    249    902  -1085   -142    -21   -313     45    531    201    384  -1998   -644 \n")
        f.write("EVD   -45.973442   0.237545\n")
        f.write("HMM        A      C      D      E      F      G      H      I      K      L      M      N      P      Q      R      S      T      V      W      Y    \n")
        f.write("         m->m   m->i   m->d   i->m   i->i   d->m   d->d   b->m   m->e\n")
        f.write("COM   hmmcalibrate myhmms\n")
        f.write("          -13      *  -6756\n")
        f.write("     1  -1698  -4236  -5399   -847  -4220  -2885  -1259   -930  -2438    406  -3428  -4768   3631  -1835  -4773  -1187  -1331   -120  -4666  -1510     1\n")
        f.write("     -   -150   -501    232     46   -382    399    104   -628    211   -461   -722    274    395     44     95    358    118   -368   -296   -251 \n")
        f.write("     C   -144  -3400 -12951    -19  -6286   -701  -1378    -13      * \n")
        f.write("//\n")        
        f.close()
        pfamDB = self.profilesDBUtils.read("dummy.hmm")
        expectedProfiles1 = Profiles()
        expectedProfiles1.name = "fn3"
        expectedProfiles1.desc = "Fibronectin type III domain"
        expectedProfiles1.length = 84
        expectedProfiles2 = Profiles()
        expectedProfiles2.name = "truc"
        expectedProfiles2.desc = ""
        expectedProfiles2.length = 123
        
        self.assertEqual( expectedProfiles1.name, pfamDB.get(0).name )
        self.assertEqual( expectedProfiles1.desc, pfamDB.get(0).desc )
        self.assertEqual( expectedProfiles1.length, pfamDB.get(0).length )
        self.assertEqual( expectedProfiles2.name, pfamDB.get(1).name )
        self.assertEqual( expectedProfiles2.desc, pfamDB.get(1).desc )
        self.assertEqual( expectedProfiles2.length, pfamDB.get(1).length )
        
        os.remove("dummy.hmm")
        
        
if __name__ == "__main__":                 
    unittest.main()         
        