import os
import unittest
from commons.core.utils.FileUtils import FileUtils
from commons.pyRepetUnit.profilesDB.ProfilesDB2Map import ProfilesDB2Map

class Test_F_ProfilesDB2Map(unittest.TestCase):
    
    def setUp(self):
        self.profilesDB2Map = ProfilesDB2Map()
        self._inputFile = "./datas/myhmms"
        self._outputFile = "./datas/outputFile.map"
        self._expectedFile = "./datas/profiles.map" 
        self._createProfilesMapFile()
        
    def tearDown(self):
        os.remove(self._outputFile)
        os.remove(self._expectedFile)
        
    def testRun(self):
        self.profilesDB2Map.setInputFile(self._inputFile)
        self.profilesDB2Map.setOutputFile(self._outputFile)
        pfamDB = self.profilesDB2Map.run()
        self.assertTrue(FileUtils.are2FilesIdentical(self._expectedFile, self._outputFile))
        
    def _createProfilesMapFile(self):
        f = open(self._expectedFile, "w")
        f.write("rrm\t\t1\t77\n")
        f.write("fn3\tFibronectin type III domain\t1\t84\n")
        f.write("pkinase\tProtein kinase domain\t1\t294\n")
        f.close()   
                   
        
if __name__ == "__main__":                 
    unittest.main()       