import unittest
import os
from commons.core.utils.FileUtils import FileUtils

class Test_F_ProfilesDB4Repet(unittest.TestCase):

    def setUp(self):
        self._inputDBFile = "%s/Tools/ProfilesDB4Repet_v2.hmm" % os.environ["REPET_DATA"]
        self._outputDBFile = "output.hmm"

    def tearDown(self):
        os.remove(self._outputDBFile)

    def test_run_as_script(self):
        cmd = "python ../ProfilesDB4Repet.py -i " + self._inputDBFile + " -o " + self._outputDBFile
        os.system(cmd)
        self.assertEqual(FileUtils.getNbLinesInSingleFile(self._outputDBFile), 375854)
        
if __name__ == "__main__":
    unittest.main()
