import unittest
import os
import time
from commons.core.utils.FileUtils import FileUtils
from commons.core.sql.DbMySql import DbMySql


class Test_ConvCoordWithOverlaps( unittest.TestCase ):
    pass

#    def setUp(self):
#        self._uniqId = "%s_%s" % ( time.strftime("%Y%m%d%H%M%S") , os.getpid() )
#        self._mapFile = "map_file.map"
#        _MockMapFile( self._mapFile )
#        self._resultFile = "dummyObsFile_%s" % ( self._uniqId )
#        self._refFileToCompare = "dummyExpFile_%s" % ( self._uniqId )
#        self._configFileName = "dummyConfigFile_%s" % ( self._uniqId )
#        configF = open(self._configFileName, "w" )
#        configF.write( "[repet_env]\n" )
#        configF.write( "repet_host: %s\n" % ( os.environ["REPET_HOST"] ) )
#        configF.write( "repet_user: %s\n" % ( os.environ["REPET_USER"] ) )
#        configF.write( "repet_pw: %s\n" % ( os.environ["REPET_PW"] ) )
#        configF.write( "repet_db: %s\n" % ( os.environ["REPET_DB"] ) )
#        configF.write( "repet_port: %s\n" % ( os.environ["REPET_PORT"] ) )
#        configF.close()
#        self._db = DbMySql( cfgFileName = self._configFileName )
#        
#    def tearDown(self):
#        os.remove( self._mapFile )
#        os.remove( self._resultFile )
#        os.remove( self._refFileToCompare )
#        self._db.close()
#        self._uniqId = None
#        
#        
#    def test_run_TwoHitsOverlapOnFirstAndSecondChunks( self ):
#        file2Process = "two_hits_overlap_on_first_and_second_chunk.align"
#        linesToProcess = [ "chunk1" + "\t" + "95535" + "\t" +  "95570" + "\t" + "sbj2" + "\t" + "125423" + "\t" +  "125467" + "\t" +  "7e-15" + "\t" + "82" + "\t" + "97.78" + "\n", 
#                           "chunk2" + "\t" +  "5544" + "\t" +    "5575" + "\t" +   "sbj2" + "\t" +   "125457"  + "\t" + "133465" + "\t" +  "2e-38" + "\t" +   "83" + "\t" +  "65" + "\n" ]
#        _MockAlignFile( file2Process, linesToProcess )
#        
#        convCoord = ConvCoord( file2Process, "q", self._mapFile, self._resultFile, "", 0, self._db )
#        convCoord.run()
#        
#        refLine = ["dmel_chr4" + "\t" + "95535" + "\t" +  "95575" + "\t" +   "sbj2" + "\t" +   "125423" + "\t" +  "133465" + "\t" + "2e-38" + "\t" +  "83" + "\t" +  "97.78" + "\n"]
#        _MockAlignFile( self._refFileToCompare, refLine )
#        
#        self.assertTrue( FileUtils.are2FilesIdentical( self._refFileToCompare, self._resultFile ) )
#        os.remove( file2Process )
#
#        
#    def test_run_ThreeHitsOverlapOnFirstAndSecondChunks( self ):
#        file2Process = "three_hits_overlap_on_first_and_second_chunk.align"
#        linesToProcess = [ "chunk1" + "\t" + "95535" + "\t" +  "95570" + "\t" + "sbj2" + "\t" + "125423" + "\t" +  "125467" + "\t" +  "7e-15" + "\t" + "82" + "\t" + "97.78" + "\n", 
#                           "chunk2" + "\t" +  "5544" + "\t" +    "5575" + "\t" +   "sbj2" + "\t" +   "125457"  + "\t" + "133465" + "\t" +  "2e-38" + "\t" +   "83" + "\t" +  "65" + "\n"
#                           "chunk2" + "\t" +  "5540" + "\t" +  "5573" + "\t" +  "sbj2" + "\t" +  "125454" + "\t"  +"125750" + "\t" + "8e-58" + "\t" +  "224" + "\t" +  "86.43" + "\n" ]
#        _MockAlignFile( file2Process, linesToProcess )
#        
#        convCoord = ConvCoord( file2Process, "q", self._mapFile, self._resultFile, "", 0, self._db )
#        convCoord.run()
#
#        refLine = ["dmel_chr4" + "\t" + "95535" + "\t" +  "95575" + "\t" +   "sbj2" + "\t" +   "125423" + "\t" +  "133465" + "\t" + "8e-58" + "\t" +  "224" + "\t" +  "97.78" + "\n"]
#        _MockAlignFile( self._refFileToCompare, refLine )
#        
#        self.assertTrue( FileUtils.are2FilesIdentical( self._refFileToCompare, self._resultFile ) )
#        os.remove( file2Process )
#
#     
#    def test_run_HitsOnDifferentStrandsAndDifferentSubjects( self ):
#        file2Process = "hits_on_different_strands_and_different_subjects.align"
#        linesToProcess = [ "chunk1" + "\t" + "95535" + "\t" +  "95570" + "\t" + "sbj2" + "\t" + "125423" + "\t" +  "125467" + "\t" +  "7e-15" + "\t" + "82" + "\t" + "97.78" + "\n", 
#                           "chunk2" + "\t" +  "5575" + "\t" +    "5544" + "\t" +   "sbj2" + "\t" +   "125457"  + "\t" + "133465" + "\t" +  "2e-38" + "\t" +   "83" + "\t" +  "65" + "\n",
#                           "chunk2" + "\t" +  "5540" + "\t" +  "5573" + "\t" +  "sbj3" + "\t" +  "125454" + "\t"  +"125750" + "\t" + "8e-58" + "\t" +  "224" + "\t" +  "86.43" + "\n" ]
#        _MockAlignFile( file2Process, linesToProcess )
#
#        convCoord = ConvCoord( file2Process, "q", self._mapFile, self._resultFile, "", 0, self._db )
#        convCoord.run()
#
#        refLine = ["dmel_chr4" + "\t" + "95535" + "\t" +  "95570" + "\t" + "sbj2" + "\t" + "125423" + "\t" +  "125467" + "\t" +  "7e-15" + "\t" + "82" + "\t" + "97.78" + "\n",
#                   "dmel_chr4" + "\t" + "95544" + "\t" +  "95575" + "\t" +   "sbj2" + "\t" +   "133465"  + "\t" + "125457" + "\t" +  "2e-38" + "\t" +   "83" + "\t" +  "65" + "\n",
#                   "dmel_chr4" + "\t" + "95540" + "\t" +  "95573" + "\t" +  "sbj3" + "\t" +  "125454" + "\t"  +"125750" + "\t" + "8e-58" + "\t" +  "224" + "\t" +  "86.43" + "\n" ]
#        _MockAlignFile( self._refFileToCompare, refLine )
#        
#        self.assertTrue( FileUtils.are2FilesIdentical( self._refFileToCompare, self._resultFile ) )
#        os.remove( file2Process )
#    
#    
#    def test_run_TwoHitsOnChunksOnlyAndOnOverlap( self ):
#        file2Process = "two_hits_on_chunks_only_and_on_overlap.align"
#        linesToProcess = [ "chunk2" + "\t" + "85000" + "\t" + "95000" + "\t" + "sbj2" + "\t" +  "125457" + "\t" + "133465" + "\t" + "2e-38" + "\t" + "83" + "\t" + "65" + "\n",
#                           "chunk3" + "\t" + "1000"  + "\t" +" 5000" + "\t" + "sbj2" + "\t" + "125454" + "\t" + "125750" + "\t" + "8e-58" + "\t" + "224" + "\t" + "86.43" + "\n" ]
#        _MockAlignFile( file2Process, linesToProcess )
#        
#        convCoord = ConvCoord( file2Process, "q", self._mapFile, self._resultFile, "", 0, self._db )
#        convCoord.run()
#        
#        refLine = ["dmel_chr4"  + "\t" + "175000"+ "\t" +  "185000"+ "\t" +  "sbj2"+ "\t" + "125454"+ "\t" + "133465"+ "\t" + "8e-58"+ "\t" + "224"+ "\t" + "86.43"+"\n"]
#        _MockAlignFile( self._refFileToCompare, refLine )
#        
#        self.assertTrue( FileUtils.are2FilesIdentical( self._refFileToCompare, self._resultFile ) )
#        os.remove( file2Process )
#
#        
#    def test_run_TwoHitsOnChunks_And_OnOverlap_OnReverseStrand_ForSubject( self ):
#        file2Process = "two_hits_on_chunks_and_on_overlap_on_reverse_strand_for_subject.align"                                   
#        linesToProcess = [ "chunk2" + "\t" + "85000" + "\t" + "95000" + "\t" + "sbj2" + "\t" + "133465"  + "\t" + "125457" + "\t" + "2e-38" + "\t" + "83" + "\t" + "65" + "\n",
#                           "chunk3" + "\t" + "1000"  + "\t" + "5000" + "\t" + "sbj2" + "\t" +  "125750" + "\t" + "125454" + "\t" + "8e-58" + "\t" + "224" + "\t" + "86.43" + "\n" ]                                                                                     
#        _MockAlignFile( file2Process, linesToProcess )
#        
#        convCoord = ConvCoord( file2Process, "q", self._mapFile, self._resultFile, "", 0, self._db )
#        convCoord.run()
#        
#        refLine = ["dmel_chr4"  + "\t" + "175000"+ "\t" +  "185000" + "\t" +  "sbj2"+ "\t" + "133465" + "\t" + "125454" + "\t" + "8e-58"+ "\t" + "224"+ "\t" + "86.43"+"\n"]
#        _MockAlignFile( self._refFileToCompare, refLine )
#        
#        self.assertTrue( FileUtils.are2FilesIdentical( self._refFileToCompare, self._resultFile ) )        
#        os.remove( file2Process )
#        
#        
#    def test_run_ThreeHitsAllByAllWithTwoHitsWithinAChunkOverlap( self ):
#        file2Process = "dummyAlignFile_%s" % ( self._uniqId )
#        linesToProcess = [ "chunk1"+"\t"+"192"+"\t"+"197"+"\t"+"chunk2"+"\t"+"2"+"\t"+"7"+"\t"+"8e-58"+"\t"+"11"+"\t"+"97.8"+"\n",
#                           "chunk1"+"\t"+"192"+"\t"+"197"+"\t"+"chunk2"+"\t"+"51"+"\t"+"56"+"\t"+"8e-58"+"\t"+"11"+"\t"+"97.8"+"\n",
#                           "chunk2"+"\t"+"2"+"\t"+"7"+"\t"+"chunk2"+"\t"+"51"+"\t"+"56"+"\t"+"8e-58"+"\t"+"11"+"\t"+"97.8"+"\n" ]
#        _MockAlignFile( file2Process, linesToProcess )
#        
#        mapFileName = "dummyMapFile_%s" % ( self._uniqId )
#        mapF = open( mapFileName, "w" )
#        mapF.write( "chunk1\tdmel_chr4\t1\t200\n" )
#        mapF.write( "chunk2\tdmel_chr4\t191\t390\n" )
#        mapF.close()
#        
#        convCoord = ConvCoord( file2Process, "qs", mapFileName, self._resultFile, "", 0, self._db )
#        convCoord.run()
#        
#        refLine = [ "dmel_chr4"+"\t"+"192"+"\t"+"197"+"\t"+"dmel_chr4"+"\t"+"241"+"\t"+"246"+"\t"+"8e-58"+"\t"+"11"+"\t"+"97.8"+"\n" ]
#        _MockAlignFile( self._refFileToCompare, refLine )
#        
#        self.assertTrue( FileUtils.are2FilesIdentical( self._refFileToCompare, self._resultFile ) )
#        os.remove( file2Process )
#        os.remove( mapFileName )
#        
#        
#class _MockAlignFile:
#    
#    def __init__(self, fileName, lines):
#        alignF = open(fileName, "w");
#        for line in lines:
#            alignF.write(line)
#        alignF.close    
#
#
#class _MockMapFile:
#    
#    def __init__ (self, fileName):
#        mapF = open(fileName, "w")
#        line1 = "chunk1" + '\t'   + "dmel_chr4" + '\t' +   "1" + '\t'+   "100000" + "\n"
#        line2 = "chunk2" + '\t'   + "dmel_chr4" + '\t' +   "90001" + '\t'+   "190000" + "\n"
#        line3 = "chunk3" + '\t'   + "dmel_chr4" + '\t' +   "180001" + '\t' + "280000" + "\n"  
#        mapF.write(line1)
#        mapF.write(line2)
#        mapF.write(line3)
#        mapF.close


test_suite = unittest.TestSuite()
test_suite.addTest( unittest.makeSuite( Test_ConvCoordWithOverlaps ) )
if __name__ == "__main__":
    unittest.TextTestRunner(verbosity=2).run( test_suite )
