import os
import unittest
from commons.pyRepetUnit.hmmer.LaunchPreProcessHmmpfamPostProcessNotInParallel import *
from pyRepet.util.file.FileUtils import *
import ConfigParser 

if (not os.environ.has_key("REPET_PATH")):
    print "*** Error: no environment variable REPET_PATH"
    exit =1 
          
if (not os.environ.has_key("PYTHONPATH")):
    print "*** Error: no environment variable PYTHONPATH"
    exit =1
    
if (exit == 1):    
    sys.exit(1)

CONFIG_FILE = "datas/configTestLaunchPreProcessHmmpfamPostProcessNotInParallel.cfg"
CURRENT_DIR = os.getcwd()

class TestLaunchPreProcessHmmpfamPostProcessNotInParallel(unittest.TestCase):
  
    def setUp( self ):
        os.chdir(CURRENT_DIR)
        self._LaunchPreProcessHmmpfamPostProcess = LaunchPreProcessHmmpfamPostProcessNotInParallel()
        self._configFile = CONFIG_FILE
        config = ConfigParser.ConfigParser()
        config.readfp(open(self._configFile))
        self._InputFile = config.get("hmmer_config", "input_file")
        self._OutputFile = config.get("hmmer_config", "output_file")        
        self.fileUtils = FileUtils()
        
    def testRun(self):
        #Normal launch
        self._LaunchPreProcessHmmpfamPostProcess.setInputFile( self._InputFile )
        self._LaunchPreProcessHmmpfamPostProcess.setOutputFile( self._OutputFile )
        self._LaunchPreProcessHmmpfamPostProcess.setConfigFile( self._configFile )
        self._LaunchPreProcessHmmpfamPostProcess.run()
        self.assertTrue(self.fileUtils.isRessourceExists(self._OutputFile))  
        self.assertFalse(self.fileUtils.isFileEmpty(self._OutputFile)) 
        os.system("rm " + self._OutputFile)
        #without config file
        configFile = "/workspace/repet_pipe/commons/pyRepetUnit/hmmer/datas/configdummy.cfg"
        self._LaunchPreProcessHmmpfamPostProcess.setConfigFile( configFile )
        self._LaunchPreProcessHmmpfamPostProcess.run()
        self.assertFalse(self.fileUtils.isRessourceExists(self._OutputFile)) 
        #without input file
        InputFile = ""
        self._LaunchPreProcessHmmpfamPostProcess.setInputFile( InputFile )
        self._LaunchPreProcessHmmpfamPostProcess.run()
        self.assertFalse(self.fileUtils.isRessourceExists(self._OutputFile))
        #without output file
        self._LaunchPreProcessHmmpfamPostProcess.setConfigFile( self._configFile )
        self._LaunchPreProcessHmmpfamPostProcess.setInputFile( self._InputFile )
        OutputFile = ""
        self._LaunchPreProcessHmmpfamPostProcess.setOutputFile( OutputFile )
        self._LaunchPreProcessHmmpfamPostProcess.run()
        self.assertFalse(self.fileUtils.isRessourceExists(self._OutputFile))
        
        
        
if __name__ == "__main__":
        unittest.main()        
