import os
import unittest
from commons.pyRepetUnit.profilesDB.Profiles import Profiles
from commons.core.utils.FileUtils import FileUtils


class TestProfiles(unittest.TestCase):

    def createInputDBFile(self):
        f = open(self._inputDBFile, "w")
        f.write("HMMER2.0  [2.3.2]\n")
        f.write("NAME  fn3\n")
        f.write("ACC   PF00041\n")
        f.write("DESC  Fibronectin type III domain\n")
        f.write("LENG  84\n")
        f.write("ALPH  Amino\n")
        f.write("RF    no\n")
        f.write("CS    yes\n")
        f.write("MAP   yes\n")
        f.write("COM   hmmbuild -A myhmms fn3.sto\n")
        f.write("COM   hmmcalibrate myhmms\n")
        f.write("NSEQ  108\n")
        f.write("DATE  Thu Jan  8 17:50:26 2009\n")
        f.write("CKSUM 6130\n")
        f.write("GA    7.8 2.0;\n")
        f.write("TC    7.9 2.1;\n")
        f.write("NC    7.0 1.1;\n")
        f.write("XT      -8455     -4  -1000  -1000  -8455     -4  -8455     -4 \n")
        f.write("NULT      -4  -8455\n")
        f.write("NULE     595  -1558     85    338   -294    453  -1158    197    249    902  -1085   -142    -21   -313     45    531    201    384  -1998   -644 \n")
        f.write("EVD   -45.973442   0.237545\n")
        f.write("HMM        A      C      D      E      F      G      H      I      K      L      M      N      P      Q      R      S      T      V      W      Y    \n")
        f.write("         m->m   m->i   m->d   i->m   i->i   d->m   d->d   b->m   m->e\n")
        f.write("COM   hmmcalibrate myhmms\n")
        f.write("          -13      *  -6756\n")
        f.write("     1  -1698  -4236  -5399   -847  -4220  -2885  -1259   -930  -2438    406  -3428  -4768   3631  -1835  -4773  -1187  -1331   -120  -4666  -1510     1\n")
        f.write("     -   -150   -501    232     46   -382    399    104   -628    211   -461   -722    274    395     44     95    358    118   -368   -296   -251 \n")
        f.write("     C   -144  -3400 -12951    -19  -6286   -701  -1378    -13      * \n")
        f.write("//\n")
        f.write("HMMER2.0  [2.3.2]\n")
        f.write("NAME  truc\n")
        f.write("ACC   PF00042.012\n")
        f.write("LENG  123\n")
        f.write("ALPH  Amino\n")
        f.write("RF    no\n")
        f.write("CS    yes\n")
        f.write("MAP   yes\n")
        f.write("COM   hmmbuild -A myhmms fn3.sto\n")
        f.write("COM   hmmcalibrate myhmms\n")
        f.write("NSEQ  108\n")
        f.write("DATE  Thu Jan  8 17:50:26 2009\n")
        f.write("CKSUM 6130\n")
        f.write("GA    7.8 -1.0;\n")
        f.write("TC    7.9 0.1;\n")
        f.write("NC    7.8 0.1;\n")
        f.write("XT      -8455     -4  -1000  -1000  -8455     -4  -8455     -4 \n")
        f.write("NULT      -4  -8455\n")
        f.write("NULE     595  -1558     85    338   -294    453  -1158    197    249    902  -1085   -142    -21   -313     45    531    201    384  -1998   -644 \n")
        f.write("EVD   -45.973442   0.237545\n")
        f.write("HMM        A      C      D      E      F      G      H      I      K      L      M      N      P      Q      R      S      T      V      W      Y    \n")
        f.write("         m->m   m->i   m->d   i->m   i->i   d->m   d->d   b->m   m->e\n")
        f.write("COM   hmmcalibrate myhmms\n")
        f.write("          -13      *  -6756\n")
        f.write("     1  -1698  -4236  -5399   -847  -4220  -2885  -1259   -930  -2438    406  -3428  -4768   3631  -1835  -4773  -1187  -1331   -120  -4666  -1510     1\n")
        f.write("     -   -150   -501    232     46   -382    399    104   -628    211   -461   -722    274    395     44     95    358    118   -368   -296   -251 \n")
        f.write("     C   -144  -3400 -12951    -19  -6286   -701  -1378    -13      * \n")
        f.write("//\n")
        f.close()
        
        
    def setUp(self):
        self.profiles = Profiles()
        self._inputDBFile = "dummy.hmm"
        
        
    def testRead(self):
        # atomic profiles file
        self.createInputDBFile()
        file = open( self._inputDBFile )
        profile = self.profiles
        profile.read(file)
        self.assertEqual("fn3",profile.name)
        self.assertEqual("Fibronectin type III domain", profile.desc)
        self.assertEqual(84, profile.length)
        self.assertEqual("PF00041", profile.accNumber)
        self.assertEqual(2.0, profile.GA_cut_off)
        profile.read(file)
        self.assertEqual("truc",profile.name)
        self.assertEqual("", profile.desc)
        self.assertEqual(123, profile.length)
        self.assertEqual("PF00042.012", profile.accNumber)
        self.assertEqual(-1.0, profile.GA_cut_off)        
        os.system("rm " + self._inputDBFile)        
        # empty file
        f = open(self._inputDBFile, "w")
        f.close()
        file = open( self._inputDBFile )
        profile = self.profiles
        profile.read(file)
        self.assertEqual(None, profile.name)
        self.assertEqual(None, profile.desc)
        self.assertEqual(None, profile.length)
        self.assertEqual(None, profile.accNumber)
        self.assertEqual(None, profile.GA_cut_off)
        os.system("rm " + self._inputDBFile)
        
        
    def testReadAndRetrieve(self):
        # atomic profiles file
        self.createInputDBFile()
        file = open( self._inputDBFile )
        profile = self.profiles
        myProfile = profile.readAndRetrieve(file)
        self.assertEqual("fn3",profile.name)
        self.assertEqual("Fibronectin type III domain", profile.desc)
        self.assertEqual(84, profile.length)
        self.assertEqual("PF00041", profile.accNumber)
        self.assertEqual(2.0, profile.GA_cut_off)
        myProfile2 = profile.readAndRetrieve(file)
        self.assertEqual("truc",profile.name)
        self.assertEqual("", profile.desc)
        self.assertEqual(123, profile.length)
        self.assertEqual("PF00042.012", profile.accNumber)
        self.assertEqual(-1.0, profile.GA_cut_off)
        #I check if retrieve work like I want
        f = open("retrieveResult", "w")
        for item in myProfile:
            f.write(item)
        for item in myProfile2:
            f.write(item)
        f.close()
        self.assertTrue(FileUtils.are2FilesIdentical("retrieveResult", self._inputDBFile))
        os.system("rm " + self._inputDBFile) 
        os.system("rm retrieveResult")       
        # empty file
        f = open(self._inputDBFile, "w")
        f.close()
        file = open( self._inputDBFile )
        profile = self.profiles
        myProfile3 = profile.readAndRetrieve(file)
        self.assertEqual(None, profile.name)
        self.assertEqual(None, profile.desc)
        self.assertEqual(None, profile.length)
        self.assertEqual(None, profile.accNumber)
        self.assertEqual(None, profile.GA_cut_off)
        self.assertEqual(None, myProfile3)
        os.system("rm " + self._inputDBFile)    
    
        
if __name__ == "__main__":                 
    unittest.main()            