import unittest
import os
from commons.core.utils.FileUtils import FileUtils

class Test_F_CompleteProfilDB(unittest.TestCase):

    def setUp(self):
        self._fileProfilesList = "./datas/ListPfamProfilsInRepbase.txt"
        self._filePfamList = "./datas/ListpfamAccNumber.txt"
        self._profilesDB = "./datas/profilesDBTest.hmm"
        self._expectedGetzCmd = "getz -e \'[pfamhmm-Id:\"zf-CCHC*\"] | [pfamhmm-Id:\"InvE*\"] | [pfamhmm-Id:\"Chromo*\"] | [pfamhmm-Id:\"TLV_coat*\"]\'"
        self._expectedFile(self._expectedGetzCmd)
        self._outputFileName = "./datas/outputFile"
        self._expectedGetzCmd2 = "getz -e \'[pfamhmm-AccNumber:\"PF00075\"] | [pfamhmm-AccNumber:\"PF00424\"] | [pfamhmm-AccNumber:\"PF00469\"]\'"
        
    def tearDown(self):
        os.remove(self._outputFileName)
        os.remove(self._expectedGetzCmdFile)

    def testCompleteProfilesDBScriptByName(self):
        Cmd = "completeProfilesDBFromAFileWithProfilesList_script.py -d " + self._profilesDB + " -l " + self._fileProfilesList + " -o " + self._outputFileName + "\n"
        os.system (Cmd)
        self.assertTrue (FileUtils.are2FilesIdentical(self._outputFileName, self._expectedGetzCmdFile))
    
    def testCompleteProfilesDBScriptByAccession(self):
        self._expectedFile(self._expectedGetzCmd2)
        Cmd = "completeProfilesDBFromAFileWithProfilesList_script.py -d " + self._profilesDB + " -l " + self._filePfamList + " -o " + self._outputFileName + " -n\n"
        os.system(Cmd)
        self.assertTrue(FileUtils.are2FilesIdentical(self._outputFileName, self._expectedGetzCmdFile))

    def _expectedFile(self, expectedGetzCmd):
        self._expectedGetzCmdFile = "./datas/expectedCmdFile"
        f = open(self._expectedGetzCmdFile, 'w')
        f.write(expectedGetzCmd)
        f.close



if __name__ == "__main__":
    unittest.main()