import unittest
import os
from commons.pyRepetUnit.profilesDB.ProfilesDB4Repet import ProfilesDB4Repet
from commons.core.utils.FileUtils import FileUtils


class Test_ProfilesDB4Repet(unittest.TestCase):

    def setUp(self):
        self._inputDBFile = "./datas/dummy.hmm"
        self._expectedDBFile = "./datas/expected.hmm"
        self._outputDBFile = "./datas/output.hmm"
        self._profilesDB4Repet = ProfilesDB4Repet()

    def tearDown(self):
        os.remove(self._expectedDBFile)
        os.remove(self._outputDBFile)
        os.remove(self._inputDBFile)

    def testFormateProfilesDB4Repet(self):
        self._createHmmFile()
        self._createExpectedHmmFile()
        self._profilesDB4Repet.setInputFile(self._inputDBFile)
        self._profilesDB4Repet.setOutputFile(self._outputDBFile)
        self._profilesDB4Repet.run()
        self.assertTrue(FileUtils.are2FilesIdentical(self._expectedDBFile, self._outputDBFile))

    def test_formateProfilesDB4Repet_GypsyDB(self):
        self._createHmmFile_GypsyDB()
        self._createExpectedHmmFile_GypsyDB()
        self._profilesDB4Repet.setInputFile(self._inputDBFile)
        self._profilesDB4Repet.setOutputFile(self._outputDBFile)
        self._profilesDB4Repet.run()
        self.assertTrue(FileUtils.are2FilesIdentical(self._expectedDBFile, self._outputDBFile))
   
    def _createExpectedHmmFile(self):
        f = open(self._expectedDBFile, "w")
        f.write("HMMER2.0  [2.3.2]\n")
        f.write("NAME  PF07582.4_AP_endonuc_2_N_APE_20.9\n")
        f.write("ACC   PF07582.4\n")
        f.write("DESC  AP endonuclease family 2 C terminus\n")
        f.write("LENG  84\n")
        f.write("ALPH  Amino\n")
        f.write("RF    no\n")
        f.write("CS    yes\n")
        f.write("MAP   yes\n")
        f.write("COM   hmmbuild -A myhmms fn3.sto\n")
        f.write("COM   hmmcalibrate myhmms\n")
        f.write("NSEQ  108\n")
        f.write("DATE  Thu Jan  8 17:50:26 2009\n")
        f.write("CKSUM 6130\n")
        f.write("GA    20.9000 20.9000;\n")
        f.write("TC    21.2000 21.2000;\n")
        f.write("NC    20.8000 20.8000;\n")
        f.write("XT      -8455     -4  -1000  -1000  -8455     -4  -8455     -4 \n")
        f.write("NULT      -4  -8455\n")
        f.write("NULE     595  -1558     85    338   -294    453  -1158    197    249    902  -1085   -142    -21   -313     45    531    201    384  -1998   -644 \n")
        f.write("EVD   -45.973442   0.237545\n")
        f.write("HMM        A      C      D      E      F      G      H      I      K      L      M      N      P      Q      R      S      T      V      W      Y    \n")
        f.write("         m->m   m->i   m->d   i->m   i->i   d->m   d->d   b->m   m->e\n")
        f.write("COM   hmmcalibrate myhmms\n")
        f.write("          -13      *  -6756\n")
        f.write("     1  -1698  -4236  -5399   -847  -4220  -2885  -1259   -930  -2438    406  -3428  -4768   3631  -1835  -4773  -1187  -1331   -120  -4666  -1510     1\n")
        f.write("     -   -150   -501    232     46   -382    399    104   -628    211   -461   -722    274    395     44     95    358    118   -368   -296   -251 \n")
        f.write("     C   -144  -3400 -12951    -19  -6286   -701  -1378    -13      * \n")
        f.write("//\n")
        f.write("HMMER2.0  [2.3.2]\n")
        f.write("NAME  PF01606.8_Arteri_env_ENV_25.0\n")
        f.write("ACC   PF01606.8\n")
        f.write("DESC  DESC  Arterivirus envelope protein\n")
        f.write("LENG  123\n")
        f.write("ALPH  Amino\n")
        f.write("RF    no\n")
        f.write("CS    yes\n")
        f.write("MAP   yes\n")
        f.write("COM   hmmbuild -A myhmms fn3.sto\n")
        f.write("COM   hmmcalibrate myhmms\n")
        f.write("NSEQ  108\n")
        f.write("DATE  Thu Jan  8 17:50:26 2009\n")
        f.write("CKSUM 6130\n")
        f.write("GA    21.0000 25.0000;\n")
        f.write("TC    306.0000 406.0000;\n")
        f.write("NC    10.3000 11.3000;\n")
        f.write("XT      -8455     -4  -1000  -1000  -8455     -4  -8455     -4 \n")
        f.write("NULT      -4  -8455\n")
        f.write("NULE     595  -1558     85    338   -294    453  -1158    197    249    902  -1085   -142    -21   -313     45    531    201    384  -1998   -644 \n")
        f.write("EVD   -45.973442   0.237545\n")
        f.write("HMM        A      C      D      E      F      G      H      I      K      L      M      N      P      Q      R      S      T      V      W      Y    \n")
        f.write("         m->m   m->i   m->d   i->m   i->i   d->m   d->d   b->m   m->e\n")
        f.write("COM   hmmcalibrate myhmms\n")
        f.write("          -13      *  -6756\n")
        f.write("     1  -1698  -4236  -5399   -847  -4220  -2885  -1259   -930  -2438    406  -3428  -4768   3631  -1835  -4773  -1187  -1331   -120  -4666  -1510     1\n")
        f.write("     -   -150   -501    232     46   -382    399    104   -628    211   -461   -722    274    395     44     95    358    118   -368   -296   -251 \n")
        f.write("     C   -144  -3400 -12951    -19  -6286   -701  -1378    -13      * \n")
        f.write("//\n")
        f.write("HMMER2.0  [2.3.2]\n")
        f.write("NAME  PF01606.8_Dummy_name_OTHER_25.0\n")
        f.write("ACC   PF01606.8\n")
        f.write("DESC  Dummy Description\n")
        f.write("LENG  123\n")
        f.write("ALPH  Amino\n")
        f.write("RF    no\n")
        f.write("CS    yes\n")
        f.write("MAP   yes\n")
        f.write("COM   hmmbuild -A myhmms fn3.sto\n")
        f.write("COM   hmmcalibrate myhmms\n")
        f.write("NSEQ  108\n")
        f.write("DATE  Thu Jan  8 17:50:26 2009\n")
        f.write("CKSUM 6130\n")
        f.write("GA    21.0000 25.0000;\n")
        f.write("TC    306.0000 406.0000;\n")
        f.write("NC    10.3000 11.3000;\n")
        f.write("XT      -8455     -4  -1000  -1000  -8455     -4  -8455     -4 \n")
        f.write("NULT      -4  -8455\n")
        f.write("NULE     595  -1558     85    338   -294    453  -1158    197    249    902  -1085   -142    -21   -313     45    531    201    384  -1998   -644 \n")
        f.write("EVD   -45.973442   0.237545\n")
        f.write("HMM        A      C      D      E      F      G      H      I      K      L      M      N      P      Q      R      S      T      V      W      Y    \n")
        f.write("         m->m   m->i   m->d   i->m   i->i   d->m   d->d   b->m   m->e\n")
        f.write("COM   hmmcalibrate myhmms\n")
        f.write("          -13      *  -6756\n")
        f.write("     1  -1698  -4236  -5399   -847  -4220  -2885  -1259   -930  -2438    406  -3428  -4768   3631  -1835  -4773  -1187  -1331   -120  -4666  -1510     1\n")
        f.write("     -   -150   -501    232     46   -382    399    104   -628    211   -461   -722    274    395     44     95    358    118   -368   -296   -251 \n")
        f.write("     C   -144  -3400 -12951    -19  -6286   -701  -1378    -13      * \n")
        f.write("//\n")
        f.close()

    def _createHmmFile(self):
        f = open(self._inputDBFile, "w")
        f.write("HMMER2.0  [2.3.2]\n")
        f.write("NAME  AP_endonuc_2_N\n")
        f.write("ACC   PF07582.4\n")
        f.write("DESC  AP endonuclease family 2 C terminus\n")
        f.write("LENG  84\n")
        f.write("ALPH  Amino\n")
        f.write("RF    no\n")
        f.write("CS    yes\n")
        f.write("MAP   yes\n")
        f.write("COM   hmmbuild -A myhmms fn3.sto\n")
        f.write("COM   hmmcalibrate myhmms\n")
        f.write("NSEQ  108\n")
        f.write("DATE  Thu Jan  8 17:50:26 2009\n")
        f.write("CKSUM 6130\n")
        f.write("GA    20.9000 20.9000;\n")
        f.write("TC    21.2000 21.2000;\n")
        f.write("NC    20.8000 20.8000;\n")
        f.write("XT      -8455     -4  -1000  -1000  -8455     -4  -8455     -4 \n")
        f.write("NULT      -4  -8455\n")
        f.write("NULE     595  -1558     85    338   -294    453  -1158    197    249    902  -1085   -142    -21   -313     45    531    201    384  -1998   -644 \n")
        f.write("EVD   -45.973442   0.237545\n")
        f.write("HMM        A      C      D      E      F      G      H      I      K      L      M      N      P      Q      R      S      T      V      W      Y    \n")
        f.write("         m->m   m->i   m->d   i->m   i->i   d->m   d->d   b->m   m->e\n")
        f.write("COM   hmmcalibrate myhmms\n")
        f.write("          -13      *  -6756\n")
        f.write("     1  -1698  -4236  -5399   -847  -4220  -2885  -1259   -930  -2438    406  -3428  -4768   3631  -1835  -4773  -1187  -1331   -120  -4666  -1510     1\n")
        f.write("     -   -150   -501    232     46   -382    399    104   -628    211   -461   -722    274    395     44     95    358    118   -368   -296   -251 \n")
        f.write("     C   -144  -3400 -12951    -19  -6286   -701  -1378    -13      * \n")
        f.write("//\n")
        f.write("HMMER2.0  [2.3.2]\n")
        f.write("NAME  Arteri_env\n")
        f.write("ACC   PF01606.8\n")
        f.write("DESC  DESC  Arterivirus envelope protein\n")
        f.write("LENG  123\n")
        f.write("ALPH  Amino\n")
        f.write("RF    no\n")
        f.write("CS    yes\n")
        f.write("MAP   yes\n")
        f.write("COM   hmmbuild -A myhmms fn3.sto\n")
        f.write("COM   hmmcalibrate myhmms\n")
        f.write("NSEQ  108\n")
        f.write("DATE  Thu Jan  8 17:50:26 2009\n")
        f.write("CKSUM 6130\n")
        f.write("GA    21.0000 25.0000;\n")
        f.write("TC    306.0000 406.0000;\n")
        f.write("NC    10.3000 11.3000;\n")
        f.write("XT      -8455     -4  -1000  -1000  -8455     -4  -8455     -4 \n")
        f.write("NULT      -4  -8455\n")
        f.write("NULE     595  -1558     85    338   -294    453  -1158    197    249    902  -1085   -142    -21   -313     45    531    201    384  -1998   -644 \n")
        f.write("EVD   -45.973442   0.237545\n")
        f.write("HMM        A      C      D      E      F      G      H      I      K      L      M      N      P      Q      R      S      T      V      W      Y    \n")
        f.write("         m->m   m->i   m->d   i->m   i->i   d->m   d->d   b->m   m->e\n")
        f.write("COM   hmmcalibrate myhmms\n")
        f.write("          -13      *  -6756\n")
        f.write("     1  -1698  -4236  -5399   -847  -4220  -2885  -1259   -930  -2438    406  -3428  -4768   3631  -1835  -4773  -1187  -1331   -120  -4666  -1510     1\n")
        f.write("     -   -150   -501    232     46   -382    399    104   -628    211   -461   -722    274    395     44     95    358    118   -368   -296   -251 \n")
        f.write("     C   -144  -3400 -12951    -19  -6286   -701  -1378    -13      * \n")
        f.write("//\n")
        f.write("HMMER2.0  [2.3.2]\n")
        f.write("NAME  Dummy_name\n")
        f.write("ACC   PF01606.8\n")
        f.write("DESC  Dummy Description\n")
        f.write("LENG  123\n")
        f.write("ALPH  Amino\n")
        f.write("RF    no\n")
        f.write("CS    yes\n")
        f.write("MAP   yes\n")
        f.write("COM   hmmbuild -A myhmms fn3.sto\n")
        f.write("COM   hmmcalibrate myhmms\n")
        f.write("NSEQ  108\n")
        f.write("DATE  Thu Jan  8 17:50:26 2009\n")
        f.write("CKSUM 6130\n")
        f.write("GA    21.0000 25.0000;\n")
        f.write("TC    306.0000 406.0000;\n")
        f.write("NC    10.3000 11.3000;\n")
        f.write("XT      -8455     -4  -1000  -1000  -8455     -4  -8455     -4 \n")
        f.write("NULT      -4  -8455\n")
        f.write("NULE     595  -1558     85    338   -294    453  -1158    197    249    902  -1085   -142    -21   -313     45    531    201    384  -1998   -644 \n")
        f.write("EVD   -45.973442   0.237545\n")
        f.write("HMM        A      C      D      E      F      G      H      I      K      L      M      N      P      Q      R      S      T      V      W      Y    \n")
        f.write("         m->m   m->i   m->d   i->m   i->i   d->m   d->d   b->m   m->e\n")
        f.write("COM   hmmcalibrate myhmms\n")
        f.write("          -13      *  -6756\n")
        f.write("     1  -1698  -4236  -5399   -847  -4220  -2885  -1259   -930  -2438    406  -3428  -4768   3631  -1835  -4773  -1187  -1331   -120  -4666  -1510     1\n")
        f.write("     -   -150   -501    232     46   -382    399    104   -628    211   -461   -722    274    395     44     95    358    118   -368   -296   -251 \n")
        f.write("     C   -144  -3400 -12951    -19  -6286   -701  -1378    -13      * \n")
        f.write("//\n")
        f.close()
        
    def _createExpectedHmmFile_GypsyDB(self):
        f = open(self._expectedDBFile, "w")
        f.write("HMMER2.0  [2.3.2]\n")
        f.write("NAME  _AP_17_6_AP_NA\n")
        f.write("LENG  97\n")
        f.write("ALPH  Amino\n")
        f.write("RF    no\n")
        f.write("CS    no\n")
        f.write("MAP   yes\n")
        f.write("COM   hmmbuild output/AP_17_6.hmm input/AP_17_6.sto\n")
        f.write("COM   hmmcalibrate output/AP_17_6.hmm\n")
        f.write("NSEQ  7\n")
        f.write("DATE  Tue Nov  3 12:11:06 2009\n")
        f.write("CKSUM 7992\n")
        f.write("XT      -8455     -4  -1000  -1000  -8455     -4  -8455     -4\n") 
        f.write("NULT      -4  -8455\n")
        f.write("NULE     595  -1558     85    338   -294    453  -1158    197    249    902  -1085   -142    -21   -313     45    531    201    384  -1998   -644\n") 
        f.write("EVD   -62.517647   0.206604\n")
        f.write("HMM        A      C      D      E      F      G      H      I      K      L      M      N      P      Q      R      S      T      V      W      Y\n")    
        f.write("         m->m   m->i   m->d   i->m   i->i   d->m   d->d   b->m   m->e\n")
        f.write("         -193      *  -2999\n")
        f.write("1  -2855  -2358  -5336  -4935  -1676  -5061  -4339   3600  -4729    809   -490  -4773  -4645  -4163  -4574  -4431  -2811     -4  -3348  -3185     1\n")
        f.write("-   -149   -500    233     43   -381    399    106   -626    210   -466   -720    275    394     45     96    359    117   -369   -294   -249\n") 
        f.write("-     -9  -7942  -8984   -894  -1115   -701  -1378   -193      *\n") 
        f.write("2  -3852  -3208  -4863  -4900    -13  -4670  -1533  -2120  -4409   1711  -1558  -3673  -4546  -3569  -4004  -4001  -3768  -2552   -797   4153    97\n")
        f.write("-      *      *      *      *      *      *      *      *      *      *      *      *      *      *      *      *      *      *      *      *\n") 
        f.write("-      *      *      *      *      *      *      *      *      0 \n")
        f.write("//\n")
        f.write("HMMER2.0  [2.3.2]\n")
        f.write("NAME  _ENV_athila_ENV_NA\n")
        f.write("LENG  647\n")
        f.write("ALPH  Amino\n")
        f.write("RF    no\n")
        f.write("CS    no\n")
        f.write("MAP   yes\n")
        f.write("COM   hmmbuild -f ENV_athila.hmm ENV_athila.txt\n")
        f.write("COM   hmmcalibrate ENV_athila.hmm\n")
        f.write("NSEQ  3\n")
        f.write("DATE  Fri Sep  9 13:24:44 2005\n")
        f.write("CKSUM 3522\n")
        f.write("XT      -8455     -4  -1000  -1000  -8455     -4  -8455     -4\n") 
        f.write("NULT      -4  -8455\n")
        f.write("NULE     595  -1558     85    338   -294    453  -1158    197    249    902  -1085   -142    -21   -313     45    531    201    384  -1998   -644\n") 
        f.write("EVD   -12.496953   0.641902\n")
        f.write("HMM        A      C      D      E      F      G      H      I      K      L      M      N      P      Q      R      S      T      V      W      Y\n")    
        f.write("         m->m   m->i   m->d   i->m   i->i   d->m   d->d   b->m   m->e\n")
        f.write("         -576      *  -1603\n")
        f.write("1   -995  -1009  -2161  -1884   -298  -2046  -1336    348  -1429    591   4179  -1738  -2255  -1394  -1460  -1476  -1060     98  -1303   -906     1\n")
        f.write("-   -149   -500    233     43   -381    399    106   -626    210   -466   -720    275    394     45     96    359    117   -369   -294   -249\n") 
        f.write("-    -33  -6075  -7117   -894  -1115   -701  -1378  -1576 -10335\n") 
        f.write("2     95   -518   -873   -904  -1785   -691   -984  -1664   -955  -1934  -1254   -652  -1327   -861  -1134   2815   -243  -1070  -2024  -1564     2\n")
        f.write("-   -149   -500    233     43   -381    399    106   -626    210   -466   -720    275    394     45     96    359    117   -369   -294   -249\n") 
        f.write("-    -33  -6075  -7117   -894  -1115   -701  -1378 -10911 -10334\n") 
        f.write("//\n")
        f.write("HMMER2.0  [2.3.2]\n")
        f.write("NAME  _ENVathila_OTHER_NA\n")
        f.write("LENG  647\n")
        f.write("ALPH  Amino\n")
        f.write("RF    no\n")
        f.write("CS    no\n")
        f.write("MAP   yes\n")
        f.write("COM   hmmbuild -f ENV_athila.hmm ENV_athila.txt\n")
        f.write("COM   hmmcalibrate ENV_athila.hmm\n")
        f.write("NSEQ  3\n")
        f.write("DATE  Fri Sep  9 13:24:44 2005\n")
        f.write("CKSUM 3522\n")
        f.write("XT      -8455     -4  -1000  -1000  -8455     -4  -8455     -4\n") 
        f.write("NULT      -4  -8455\n")
        f.write("NULE     595  -1558     85    338   -294    453  -1158    197    249    902  -1085   -142    -21   -313     45    531    201    384  -1998   -644\n") 
        f.write("EVD   -12.496953   0.641902\n")
        f.write("HMM        A      C      D      E      F      G      H      I      K      L      M      N      P      Q      R      S      T      V      W      Y\n")    
        f.write("         m->m   m->i   m->d   i->m   i->i   d->m   d->d   b->m   m->e\n")
        f.write("         -576      *  -1603\n")
        f.write("1   -995  -1009  -2161  -1884   -298  -2046  -1336    348  -1429    591   4179  -1738  -2255  -1394  -1460  -1476  -1060     98  -1303   -906     1\n")
        f.write("-   -149   -500    233     43   -381    399    106   -626    210   -466   -720    275    394     45     96    359    117   -369   -294   -249\n") 
        f.write("-    -33  -6075  -7117   -894  -1115   -701  -1378  -1576 -10335\n") 
        f.write("2     95   -518   -873   -904  -1785   -691   -984  -1664   -955  -1934  -1254   -652  -1327   -861  -1134   2815   -243  -1070  -2024  -1564     2\n")
        f.write("-   -149   -500    233     43   -381    399    106   -626    210   -466   -720    275    394     45     96    359    117   -369   -294   -249\n") 
        f.write("-    -33  -6075  -7117   -894  -1115   -701  -1378 -10911 -10334\n") 
        f.write("//\n")
        f.write("HMMER2.0  [2.3.2]\n")
        f.write("NAME  _MOV_cavemovirus_OTHER_NA\n")
        f.write("LENG  302\n")
        f.write("ALPH  Amino\n")
        f.write("RF    no\n")
        f.write("CS    no\n")
        f.write("MAP   yes\n")
        f.write("COM   hmmbuild output/MOV_cavemovirus.hmm input/MOV_cavemovirus.sto\n")
        f.write("COM   hmmcalibrate output/MOV_cavemovirus.hmm\n")
        f.write("NSEQ  2\n")
        f.write("DATE  Tue Nov  3 11:25:12 2009\n")
        f.write("CKSUM 1918\n")
        f.write("XT      -8455     -4  -1000  -1000  -8455     -4  -8455     -4\n") 
        f.write("NULT      -4  -8455\n")
        f.write("NULE     595  -1558     85    338   -294    453  -1158    197    249    902  -1085   -142    -21   -313     45    531    201    384  -1998   -644\n") 
        f.write("EVD   -135.876633   0.154850\n")
        f.write("HMM        A      C      D      E      F      G      H      I      K      L      M      N      P      Q      R      S      T      V      W      Y\n")    
        f.write("         m->m   m->i   m->d   i->m   i->i   d->m   d->d   b->m   m->e\n")
        f.write("         -585      *  -1585\n")
        f.write("1  -1028  -1686   -800   -442  -2171  -1521   -263  -1873   3103  -1859  -1251   -547  -1750     74    599  -1004   -972  -1620  -1812  -1528     5\n")
        f.write("-   -149   -500    233     43   -381    399    106   -626    210   -466   -720    275    394     45     96    359    117   -369   -294   -249\n") 
        f.write("-    -33  -6045  -7087   -894  -1115   -701  -1378   -585      *\n") 
        f.write("2  -1016   -805  -2637  -2367   -591  -2470  -1853   3039  -2040    329    346  -2180  -2589  -1943  -2070  -1879  -1051   1184  -1698  -1261     6\n")
        f.write("-   -149   -500    233     43   -381    399    106   -626    210   -466   -720    275    394     45     96    359    117   -369   -294   -249\n") 
        f.write("-    -33  -6045  -7087   -894  -1115   -701  -1378      *      *\n") 
        f.write("3  -1016   -805  -2637  -2367   -591  -2470  -1853   3039  -2040    329    346  -2180  -2589  -1943  -2070  -1879  -1051   1184  -1698  -1261     7\n")
        f.write("-   -149   -500    233     43   -381    399    106   -626    210   -466   -720    275    394     45     96    359    117   -369   -294   -249\n") 
        f.write("-    -33  -6045  -7087   -894  -1115   -701  -1378      *      *\n") 
        f.write("//\n")
        f.close()

    def _createHmmFile_GypsyDB(self):
        f = open(self._inputDBFile, "w")
        f.write("HMMER2.0  [2.3.2]\n")
        f.write("NAME  AP_17_6\n")
        f.write("LENG  97\n")
        f.write("ALPH  Amino\n")
        f.write("RF    no\n")
        f.write("CS    no\n")
        f.write("MAP   yes\n")
        f.write("COM   hmmbuild output/AP_17_6.hmm input/AP_17_6.sto\n")
        f.write("COM   hmmcalibrate output/AP_17_6.hmm\n")
        f.write("NSEQ  7\n")
        f.write("DATE  Tue Nov  3 12:11:06 2009\n")
        f.write("CKSUM 7992\n")
        f.write("XT      -8455     -4  -1000  -1000  -8455     -4  -8455     -4\n") 
        f.write("NULT      -4  -8455\n")
        f.write("NULE     595  -1558     85    338   -294    453  -1158    197    249    902  -1085   -142    -21   -313     45    531    201    384  -1998   -644\n") 
        f.write("EVD   -62.517647   0.206604\n")
        f.write("HMM        A      C      D      E      F      G      H      I      K      L      M      N      P      Q      R      S      T      V      W      Y\n")    
        f.write("         m->m   m->i   m->d   i->m   i->i   d->m   d->d   b->m   m->e\n")
        f.write("         -193      *  -2999\n")
        f.write("1  -2855  -2358  -5336  -4935  -1676  -5061  -4339   3600  -4729    809   -490  -4773  -4645  -4163  -4574  -4431  -2811     -4  -3348  -3185     1\n")
        f.write("-   -149   -500    233     43   -381    399    106   -626    210   -466   -720    275    394     45     96    359    117   -369   -294   -249\n") 
        f.write("-     -9  -7942  -8984   -894  -1115   -701  -1378   -193      *\n") 
        f.write("2  -3852  -3208  -4863  -4900    -13  -4670  -1533  -2120  -4409   1711  -1558  -3673  -4546  -3569  -4004  -4001  -3768  -2552   -797   4153    97\n")
        f.write("-      *      *      *      *      *      *      *      *      *      *      *      *      *      *      *      *      *      *      *      *\n") 
        f.write("-      *      *      *      *      *      *      *      *      0 \n")
        f.write("//\n")
        f.write("HMMER2.0  [2.3.2]\n")
        f.write("NAME  ENV_athila\n")
        f.write("LENG  647\n")
        f.write("ALPH  Amino\n")
        f.write("RF    no\n")
        f.write("CS    no\n")
        f.write("MAP   yes\n")
        f.write("COM   hmmbuild -f ENV_athila.hmm ENV_athila.txt\n")
        f.write("COM   hmmcalibrate ENV_athila.hmm\n")
        f.write("NSEQ  3\n")
        f.write("DATE  Fri Sep  9 13:24:44 2005\n")
        f.write("CKSUM 3522\n")
        f.write("XT      -8455     -4  -1000  -1000  -8455     -4  -8455     -4\n") 
        f.write("NULT      -4  -8455\n")
        f.write("NULE     595  -1558     85    338   -294    453  -1158    197    249    902  -1085   -142    -21   -313     45    531    201    384  -1998   -644\n") 
        f.write("EVD   -12.496953   0.641902\n")
        f.write("HMM        A      C      D      E      F      G      H      I      K      L      M      N      P      Q      R      S      T      V      W      Y\n")    
        f.write("         m->m   m->i   m->d   i->m   i->i   d->m   d->d   b->m   m->e\n")
        f.write("         -576      *  -1603\n")
        f.write("1   -995  -1009  -2161  -1884   -298  -2046  -1336    348  -1429    591   4179  -1738  -2255  -1394  -1460  -1476  -1060     98  -1303   -906     1\n")
        f.write("-   -149   -500    233     43   -381    399    106   -626    210   -466   -720    275    394     45     96    359    117   -369   -294   -249\n") 
        f.write("-    -33  -6075  -7117   -894  -1115   -701  -1378  -1576 -10335\n") 
        f.write("2     95   -518   -873   -904  -1785   -691   -984  -1664   -955  -1934  -1254   -652  -1327   -861  -1134   2815   -243  -1070  -2024  -1564     2\n")
        f.write("-   -149   -500    233     43   -381    399    106   -626    210   -466   -720    275    394     45     96    359    117   -369   -294   -249\n") 
        f.write("-    -33  -6075  -7117   -894  -1115   -701  -1378 -10911 -10334\n") 
        f.write("//\n")
        f.write("HMMER2.0  [2.3.2]\n")
        f.write("NAME  ENVathila\n")
        f.write("LENG  647\n")
        f.write("ALPH  Amino\n")
        f.write("RF    no\n")
        f.write("CS    no\n")
        f.write("MAP   yes\n")
        f.write("COM   hmmbuild -f ENV_athila.hmm ENV_athila.txt\n")
        f.write("COM   hmmcalibrate ENV_athila.hmm\n")
        f.write("NSEQ  3\n")
        f.write("DATE  Fri Sep  9 13:24:44 2005\n")
        f.write("CKSUM 3522\n")
        f.write("XT      -8455     -4  -1000  -1000  -8455     -4  -8455     -4\n") 
        f.write("NULT      -4  -8455\n")
        f.write("NULE     595  -1558     85    338   -294    453  -1158    197    249    902  -1085   -142    -21   -313     45    531    201    384  -1998   -644\n") 
        f.write("EVD   -12.496953   0.641902\n")
        f.write("HMM        A      C      D      E      F      G      H      I      K      L      M      N      P      Q      R      S      T      V      W      Y\n")    
        f.write("         m->m   m->i   m->d   i->m   i->i   d->m   d->d   b->m   m->e\n")
        f.write("         -576      *  -1603\n")
        f.write("1   -995  -1009  -2161  -1884   -298  -2046  -1336    348  -1429    591   4179  -1738  -2255  -1394  -1460  -1476  -1060     98  -1303   -906     1\n")
        f.write("-   -149   -500    233     43   -381    399    106   -626    210   -466   -720    275    394     45     96    359    117   -369   -294   -249\n") 
        f.write("-    -33  -6075  -7117   -894  -1115   -701  -1378  -1576 -10335\n") 
        f.write("2     95   -518   -873   -904  -1785   -691   -984  -1664   -955  -1934  -1254   -652  -1327   -861  -1134   2815   -243  -1070  -2024  -1564     2\n")
        f.write("-   -149   -500    233     43   -381    399    106   -626    210   -466   -720    275    394     45     96    359    117   -369   -294   -249\n") 
        f.write("-    -33  -6075  -7117   -894  -1115   -701  -1378 -10911 -10334\n") 
        f.write("//\n")
        f.write("HMMER2.0  [2.3.2]\n")
        f.write("NAME  MOV_cavemovirus\n")
        f.write("LENG  302\n")
        f.write("ALPH  Amino\n")
        f.write("RF    no\n")
        f.write("CS    no\n")
        f.write("MAP   yes\n")
        f.write("COM   hmmbuild output/MOV_cavemovirus.hmm input/MOV_cavemovirus.sto\n")
        f.write("COM   hmmcalibrate output/MOV_cavemovirus.hmm\n")
        f.write("NSEQ  2\n")
        f.write("DATE  Tue Nov  3 11:25:12 2009\n")
        f.write("CKSUM 1918\n")
        f.write("XT      -8455     -4  -1000  -1000  -8455     -4  -8455     -4\n") 
        f.write("NULT      -4  -8455\n")
        f.write("NULE     595  -1558     85    338   -294    453  -1158    197    249    902  -1085   -142    -21   -313     45    531    201    384  -1998   -644\n") 
        f.write("EVD   -135.876633   0.154850\n")
        f.write("HMM        A      C      D      E      F      G      H      I      K      L      M      N      P      Q      R      S      T      V      W      Y\n")    
        f.write("         m->m   m->i   m->d   i->m   i->i   d->m   d->d   b->m   m->e\n")
        f.write("         -585      *  -1585\n")
        f.write("1  -1028  -1686   -800   -442  -2171  -1521   -263  -1873   3103  -1859  -1251   -547  -1750     74    599  -1004   -972  -1620  -1812  -1528     5\n")
        f.write("-   -149   -500    233     43   -381    399    106   -626    210   -466   -720    275    394     45     96    359    117   -369   -294   -249\n") 
        f.write("-    -33  -6045  -7087   -894  -1115   -701  -1378   -585      *\n") 
        f.write("2  -1016   -805  -2637  -2367   -591  -2470  -1853   3039  -2040    329    346  -2180  -2589  -1943  -2070  -1879  -1051   1184  -1698  -1261     6\n")
        f.write("-   -149   -500    233     43   -381    399    106   -626    210   -466   -720    275    394     45     96    359    117   -369   -294   -249\n") 
        f.write("-    -33  -6045  -7087   -894  -1115   -701  -1378      *      *\n") 
        f.write("3  -1016   -805  -2637  -2367   -591  -2470  -1853   3039  -2040    329    346  -2180  -2589  -1943  -2070  -1879  -1051   1184  -1698  -1261     7\n")
        f.write("-   -149   -500    233     43   -381    399    106   -626    210   -466   -720    275    394     45     96    359    117   -369   -294   -249\n") 
        f.write("-    -33  -6045  -7087   -894  -1115   -701  -1378      *      *\n") 
        f.write("//\n")
        f.close()     


if __name__ == "__main__":
    unittest.main()