#
# Copyright INRA-URGI 2009-2010
# 
# This software is governed by the CeCILL license under French law and
# abiding by the rules of distribution of free software. You can use,
# modify and/ or redistribute the software under the terms of the CeCILL
# license as circulated by CEA, CNRS and INRIA at the following URL
# "http://www.cecill.info".
# 
# As a counterpart to the access to the source code and rights to copy,
# modify and redistribute granted by the license, users are provided only
# with a limited warranty and the software's author, the holder of the
# economic rights, and the successive licensors have only limited
# liability.
# 
# In this respect, the user's attention is drawn to the risks associated
# with loading, using, modifying and/or developing or reproducing the
# software by the user in light of its specific status of free software,
# that may mean that it is complicated to manipulate, and that also
# therefore means that it is reserved for developers and experienced
# professionals having in-depth computer knowledge. Users are therefore
# encouraged to load and test the software's suitability as regards their
# requirements in conditions enabling the security of their systems and/or
# data to be ensured and, more generally, to use and operate it in the
# same conditions as regards security.
# 
# The fact that you are presently reading this means that you have had
# knowledge of the CeCILL license and that you accept its terms.
#
import sys
from SMART.Java.Python.cleaning.TranscriptListCleaner import TranscriptListCleaner
from SMART.Java.Python.cleaning.GffCleaner import GffCleaner
from SMART.Java.Python.cleaning.GtfCleaner import GtfCleaner
from SMART.Java.Python.cleaning.DefaultCleaner import DefaultCleaner

#Attention!! Do not delete the imports!! They are used to know the type of file format!!!

class CleanerChooser(object):
	"""
	A class that finds the correct cleaner
	@ivar format: the format
	@type format: string
	@ivar cleaner: the parser
	@type cleaner: object
	@ivar cleanerClass: the class of the parser
	@type cleanerClass: class
	@ivar verbosity: verbosity
	@type verbosity: int		
	"""

	def __init__(self, verbosity = 0):
		"""
		Constructor
		@param verbosity: verbosity
		@type verbosity: int
		"""
		self.verbosity = verbosity
	

	def findFormat(self, format):
		"""
		Find the correct parser
		@ivar format: the format
		@type format: string
		@return: a cleaner
		"""
		for cleanerClass in TranscriptListCleaner.__subclasses__():
			if cleanerClass != None:
				if cleanerClass.getFileFormats() != None and format in cleanerClass.getFileFormats():
					self.cleanerClass = cleanerClass
					return
		self.cleanerClass = DefaultCleaner


	def getCleaner(self):
		"""
		Get the parser previously found
		@return: the parser
		"""
		return self.cleanerClass(self.verbosity)
