import unittest
import os
from commons.core.utils.FileUtils import FileUtils

TestF_PATH = os.environ['REPET_PATH'] + '/SMART/Java/Python/TestFiles'


class Test_F_plot(unittest.TestCase):
    
    def setUp(self):
        self.outputFileName = "testOut.png"

    def tearDown(self):
        os.remove(self.outputFileName)

    def test_run_default_option(self):
        cmd = "python ../plot.py -i %s/mapperAnalyzerOutput.gff3 -f gff3 -x identity -y nbMismatches -s line -o %s " % (TestF_PATH, self.outputFileName)
        os.system(cmd)
        self.assertTrue(FileUtils.isRessourceExists(self.outputFileName))

    def test_run_log_option(self):
        cmd = "python ../plot.py -i %s/mapperAnalyzerOutput.gff3 -f gff3 -x identity -y nbMismatches -s line -o %s -l xy" % (TestF_PATH, self.outputFileName)
        os.system(cmd)
        self.assertTrue(FileUtils.isRessourceExists(self.outputFileName))
        
    def test_run_z_xDefault_yDefault_heatPoints_option(self):
        cmd = "python ../plot.py -i %s/testPlot.gff3 -f gff3 -x value1 -X 1 -y value2 -Y 1 -z value3 -s heatPoints -o %s -v 10 " % (TestF_PATH, self.outputFileName)
        os.system(cmd)
        self.assertTrue(FileUtils.isRessourceExists(self.outputFileName))
        
    def test_points_option(self):
        cmd = "python ../plot.py -i %s/testPlot.gff3 -f gff3 -x value1 -X 1 -y value2 -Y 1 -s points -o %s -v 10 " % (TestF_PATH, self.outputFileName)
        os.system(cmd)
        self.assertTrue(FileUtils.isRessourceExists(self.outputFileName))
        
    def test_xDefault_points_option(self):
        cmd = "python ../plot.py -i %s/testPlot.gff3 -f gff3 -x value1 -X 1 -n 2 -s barplot -o %s -v 10 " % (TestF_PATH, self.outputFileName)
        os.system(cmd)
        self.assertTrue(FileUtils.isRessourceExists(self.outputFileName))
    
if __name__ == "__main__":
    unittest.main()