import unittest
import os, os.path
from SMART.Java.Python.ncList.FindOverlapsWithSeveralIntervals import FindOverlapsWithSeveralIntervals
from SMART.Java.Python.misc import Utils

class Test_F_FindOverlapsWithSeveralIntervals(unittest.TestCase):

    def setUp(self):
        self._inputRefGff3FileName   = 'sorted_Ref.gff3'
        self._inputQueryGff3FileName = 'sorted_Query.gff3'
        self._outputGff3FileName     = 'output.gff3'
        self._expOutputFileName      = 'expOutGff3.gff3'
        self._writeQueryGff3File(self._inputQueryGff3FileName)
        self._writeGFF3File(self._inputRefGff3FileName)
        self._iFOWSI = FindOverlapsWithSeveralIntervals(0)
        self._iFOWSI.setRefFileName(self._inputRefGff3FileName, "gff3")
        self._iFOWSI.setQueryFileName(self._inputQueryGff3FileName, "gff3")
        self._iFOWSI.setOutputFileName(self._outputGff3FileName)
        self._iFOWSI.prepareIntermediateFiles()
        self._iFOWSI.createNCLists()
        
    def tearDown(self):
        for fileName in (self._inputRefGff3FileName, self._inputQueryGff3FileName, self._outputGff3FileName, self._expOutputFileName):
            if os.path.exists(fileName):
                os.remove(fileName)
        
    def test_run_general(self):
        self._writeQueryGff3File(self._inputQueryGff3FileName)
        self._writeGFF3File(self._inputRefGff3FileName)
        self._iFOWSI = FindOverlapsWithSeveralIntervals(0)
        self._iFOWSI.setRefFileName(self._inputRefGff3FileName, "gff3")
        self._iFOWSI.setQueryFileName(self._inputQueryGff3FileName, "gff3")
        self._iFOWSI.setOutputFileName(self._outputGff3FileName)
        self._iFOWSI.prepareIntermediateFiles()
        self._iFOWSI.createNCLists()
        self._iFOWSI.compare()
        self._iFOWSI.close()
        self._writeExpOutFile_general(self._expOutputFileName)
        self.assertTrue(Utils.diff(self._expOutputFileName, self._outputGff3FileName))  
        
    def test_run_general_asScript(self):
        cmd = 'python ../FindOverlapsWithSeveralIntervals.py -i %s -f gff3 -j %s -g gff3 -o %s -v 0' % (self._inputQueryGff3FileName, self._inputRefGff3FileName, self._outputGff3FileName)      
        os.system(cmd)
        self._writeExpOutFile_general(self._expOutputFileName)
        self.assertTrue(Utils.diff(self._expOutputFileName, self._outputGff3FileName))         

      
    def test_run_overlap_special_case(self):
        inputQueryGff3FileName = 'query2.gff3'
        self._writeQueryGff3File2(inputQueryGff3FileName)
        self._iFOWSI = FindOverlapsWithSeveralIntervals(0)
        self._iFOWSI.setRefFileName(self._inputRefGff3FileName, "gff3")
        self._iFOWSI.setQueryFileName(inputQueryGff3FileName, "gff3")
        self._iFOWSI.setOutputFileName(self._outputGff3FileName)
        self._iFOWSI.prepareIntermediateFiles()
        self._iFOWSI.createNCLists()
        self._iFOWSI.compare()
        self._iFOWSI.close()
        self._writeExpOutFile_special_case(self._expOutputFileName)        
        self.assertTrue(Utils.diff(self._expOutputFileName, self._outputGff3FileName))   
        os.remove(inputQueryGff3FileName) 
        
    def test_run_overlap_special_case_asScript(self):
        inputQueryGff3FileName = 'query2.gff3'
        self._writeQueryGff3File2(inputQueryGff3FileName)
        cmd = 'python ../FindOverlapsWithSeveralIntervals.py -i %s -f gff3 -j %s -g gff3 -o %s -v 0' % (inputQueryGff3FileName, self._inputRefGff3FileName, self._outputGff3FileName)      
        os.system(cmd) 
        self._writeExpOutFile_special_case(self._expOutputFileName)        
        self.assertTrue(Utils.diff(self._expOutputFileName, self._outputGff3FileName))         
        os.remove(inputQueryGff3FileName) 
                
    def _writeExpOutFile_special_case(self, fileName):
        f = open(fileName, 'w')
        f.write("chr1	S-MART	test2	1250	1300	781	+	.	nbOverlaps=1;overlapsWith=test2.7;ID=query_2;Name=test1.2\n")
        f.close() 
        
    def _writeExpOutFile_general(self, fileName):
        f = open(fileName, 'w')
        f.write("""chr1	S-MART	test1.1	25	150	126	+	.	nbOverlaps=3;overlapsWith=test2.1--test2.2--test2.3;ID=query_1;Name=test1.1
chr1	S-MART	test1.2	70	850	781	+	.	nbOverlaps=6;overlapsWith=test2.1--test2.2--test2.3--test2.4--test2.5--test2.6;ID=query_2;Name=test1.2
chr1	S-MART	test1.3	550	850	201	+	.	nbOverlaps=4;overlapsWith=test2.1--test2.3--test2.5--test2.6;ID=query_3;Name=test1.3
chr1	S-MART	test1.4	925	1025	101	+	.	nbOverlaps=2;overlapsWith=test2.1--test2.5;ID=query_4;Name=test1.4
chr1	S-MART	test1.5	1201	1210	10	+	.	nbOverlaps=1;overlapsWith=test2.7;ID=query_5;Name=test1.5
""")
        f.close() 

    def _writeExpOutFile_cas_1(self, fileName):
        f = open(fileName, 'w')
        f.write("chr1\tS-MART\ttest2.1\t9\t1000\t1001\t+\t.\tName=test2.1;OverlapWith=query_3;score=1001;feature=test2.1;ID=test2.1\n")
        f.write("chr1\tS-MART\ttest2.3\t100\t600\t501\t+\t.\tName=test2.3;OverlapWith=query_3;score=501;feature=test2.3;ID=test2.3\n")
        f.write("chr1\tS-MART\ttest2.5\t700\t950\t251\t+\t.\tName=test2.5;OverlapWith=query_3;score=251;feature=test2.5;ID=test2.5\n")
        f.write("chr1\tS-MART\ttest2.6\t800\t900\t101\t+\t.\tName=test2.6;OverlapWith=query_3;score=101;feature=test2.6;ID=test2.6\n")
        f.close()         

    def _writeExpOutFile_cas_2(self, fileName):
        f = open(fileName, 'w')
        f.write("chr1\tS-MART\ttest2.1\t9\t1000\t1001\t+\t.\tName=test2.1;OverlapWith=query_2;score=1001;feature=test2.1;ID=test2.1\n")
        f.write("chr1\tS-MART\ttest2.2\t50\t350\t301\t+\t.\tName=test2.2;OverlapWith=query_2;score=301;feature=test2.2;ID=test2.2\n")
        f.write("chr1\tS-MART\ttest2.3\t100\t600\t501\t+\t.\tName=test2.3;OverlapWith=query_2;score=501;feature=test2.3;ID=test2.3\n")
        f.write("chr1\tS-MART\ttest2.4\t200\t450\t251\t+\t.\tName=test2.4;OverlapWith=query_2;score=251;feature=test2.4;ID=test2.4\n")
        f.write("chr1\tS-MART\ttest2.5\t700\t950\t251\t+\t.\tName=test2.5;OverlapWith=query_2;score=251;feature=test2.5;ID=test2.5\n")
        f.write("chr1\tS-MART\ttest2.6\t800\t900\t101\t+\t.\tName=test2.6;OverlapWith=query_2;score=101;feature=test2.6;ID=test2.6\n")
        f.write("chr1\tS-MART\ttest2.1\t9\t1000\t1001\t+\t.\tName=test2.1;OverlapWith=query_3;score=1001;feature=test2.1;ID=test2.1\n")
        f.write("chr1\tS-MART\ttest2.3\t100\t600\t501\t+\t.\tName=test2.3;OverlapWith=query_3;score=501;feature=test2.3;ID=test2.3\n")
        f.write("chr1\tS-MART\ttest2.5\t700\t950\t251\t+\t.\tName=test2.5;OverlapWith=query_3;score=251;feature=test2.5;ID=test2.5\n")
        f.write("chr1\tS-MART\ttest2.6\t800\t900\t101\t+\t.\tName=test2.6;OverlapWith=query_3;score=101;feature=test2.6;ID=test2.6\n")
        f.close() 

    def _writeExpOutFile_all_overlap(self, fileName):
        f = open(fileName, 'w')
        f.write("chr1\tS-MART\ttest2.1\t9\t1000\t1001\t+\t.\tName=test2.1;OverlapWith=query_2;score=1001;feature=test2.1;ID=test2.1\n")
        f.write("chr1\tS-MART\ttest2.2\t50\t350\t301\t+\t.\tName=test2.2;OverlapWith=query_2;score=301;feature=test2.2;ID=test2.2\n")
        f.write("chr1\tS-MART\ttest2.3\t100\t600\t501\t+\t.\tName=test2.3;OverlapWith=query_2;score=501;feature=test2.3;ID=test2.3\n")
        f.write("chr1\tS-MART\ttest2.4\t200\t450\t251\t+\t.\tName=test2.4;OverlapWith=query_2;score=251;feature=test2.4;ID=test2.4\n")
        f.write("chr1\tS-MART\ttest2.5\t700\t950\t251\t+\t.\tName=test2.5;OverlapWith=query_2;score=251;feature=test2.5;ID=test2.5\n")
        f.write("chr1\tS-MART\ttest2.6\t800\t900\t101\t+\t.\tName=test2.6;OverlapWith=query_2;score=101;feature=test2.6;ID=test2.6\n")
        f.close()           

    def _writeExpOutFile_overlap_to_children(self, fileName):
        f = open(fileName, 'w')
        f.write("chr1\tS-MART\ttest2.1\t9\t1000\t1001\t+\t.\tName=test2.1;OverlapWith=query_3;score=1001;feature=test2.1;ID=test2.1\n") 
        f.write("chr1\tS-MART\ttest2.3\t100\t600\t501\t+\t.\tName=test2.3;OverlapWith=query_3;score=501;feature=test2.3;ID=test2.3\n") 
        f.write("chr1\tS-MART\ttest2.5\t700\t950\t251\t+\t.\tName=test2.5;OverlapWith=query_3;score=251;feature=test2.5;ID=test2.5\n") 
        f.write("chr1\tS-MART\ttest2.6\t800\t900\t101\t+\t.\tName=test2.6;OverlapWith=query_3;score=101;feature=test2.6;ID=test2.6\n") 
        f.close()         

    def _writeExpOutFile_not_overlap_to_children(self, fileName):
        f = open(fileName, 'w')
        f.write("chr1\tS-MART\ttest2.1\t9\t1000\t1001\t+\t.\tName=test2.1;OverlapWith=query_1;score=1001;feature=test2.1;ID=test2.1\n")
        f.write("chr1\tS-MART\ttest2.2\t50\t350\t301\t+\t.\tName=test2.2;OverlapWith=query_1;score=301;feature=test2.2;ID=test2.2\n")
        f.write("chr1\tS-MART\ttest2.3\t100\t600\t501\t+\t.\tName=test2.3;OverlapWith=query_1;score=501;feature=test2.3;ID=test2.3\n")
        f.write("chr1\tS-MART\ttest2.1\t9\t1000\t1001\t+\t.\tName=test2.1;OverlapWith=query_4;score=1001;feature=test2.1;ID=test2.1\n")
        f.write("chr1\tS-MART\ttest2.5\t700\t950\t251\t+\t.\tName=test2.5;OverlapWith=query_4;score=251;feature=test2.5;ID=test2.5\n")
        f.close()        

    def _writeExpOutFile_no_overlap_right(self, fileName):
        f = open(fileName, 'w')
        f.close()                 

    def _writeExpOutFile_one_overlap(self, fileName):
        f = open(fileName, 'w')
        f.write("chr1\tS-MART\ttest2.7\t1200\t1300\t101\t+\t.\tName=test2.7;OverlapWith=query_5;score=101;feature=test2.7;ID=test2.7\n")
        f.close()        
        
    def _writeQueryGff3File2(self, fileName):
        f = open(fileName, 'w')
        f.write("chr1\tquery\ttest1\t1100\t1150\t126\t+\t.\tID=query_1;Name=test1.1\n")
        f.write("chr1\tquery\ttest2\t1250\t1300\t781\t+\t.\tID=query_2;Name=test1.2\n")
        f.close()
        
    def _writeQueryGff3File(self, fileName):
        f = open(fileName, 'w')
        f.write("chr1\tquery\ttest1.1\t25\t150\t126\t+\t.\tID=query_1;Name=test1.1\n")
        f.write("chr1\tquery\ttest1.2\t70\t850\t781\t+\t.\tID=query_2;Name=test1.2\n")
        f.write("chr1\tquery\ttest1.3\t550\t850\t201\t+\t.\tID=query_3;Name=test1.3\n")
        f.write("chr1\tquery\ttest1.4\t925\t1025\t101\t+\t.\tID=query_4;Name=test1.4\n")
        f.write("chr1\tquery\ttest1.5\t1201\t1210\t10\t+\t.\tID=query_5;Name=test1.5\n")
        f.write("chr1\tquery\ttest1.6\t1500\t1600\t101\t+\t.\tID=query_6;Name=test1.6\n")
        f.close()
        
    def _writeGFF3File(self, fileName):
        f = open(fileName, "w")
        f.write("chr1\ttest\ttest2.1\t9\t1000\t1001\t+\t.\tID=test2.1;Name=test2.1\n")
        f.write("chr1\ttest\ttest2.2\t50\t350\t301\t+\t.\tID=test2.2;Name=test2.2\n")
        f.write("chr1\ttest\ttest2.3\t100\t600\t501\t+\t.\tID=test2.3;Name=test2.3\n")
        f.write("chr1\ttest\ttest2.4\t200\t450\t251\t+\t.\tID=test2.4;Name=test2.4\n")
        f.write("chr1\ttest\ttest2.5\t700\t950\t251\t+\t.\tID=test2.5;Name=test2.5\n")
        f.write("chr1\ttest\ttest2.6\t800\t900\t101\t+\t.\tID=test2.6;Name=test2.6\n")
        f.write("chr1\ttest\ttest2.7\t1200\t1300\t101\t+\t.\tID=test2.7;Name=test2.7\n")
        f.close()
        
if __name__ == "__main__":
    unittest.main()
