import os
import unittest
from commons.core.sql.TableJobAdaptatorFactory import TableJobAdaptatorFactory
from commons.core.sql.DbFactory import DbFactory

class Test_TableJobAdaptatorFactory(unittest.TestCase):

    def test_createInstance_SGE(self):
        REPET_JOB_MANAGER_Initial_Value = os.environ["REPET_JOB_MANAGER"]
        os.environ["REPET_JOB_MANAGER"] = "SGE"
        instance = TableJobAdaptatorFactory.createInstance(DbFactory.createInstance(), "dummyJobTable")
        obsClassName = instance.__class__.__name__
        expClassName = "TableJobAdaptatorSGE"
        os.environ["REPET_JOB_MANAGER"] = REPET_JOB_MANAGER_Initial_Value
        self.assertEquals(expClassName, obsClassName)

    def test_createInstance_Torque(self):
        REPET_JOB_MANAGER_Initial_Value = os.environ["REPET_JOB_MANAGER"]
        os.environ["REPET_JOB_MANAGER"] = "Torque"
        instance = TableJobAdaptatorFactory.createInstance(DbFactory.createInstance(), "dummyJobTable")
        obsClassName = instance.__class__.__name__
        expClassName = "TableJobAdaptatorTorque"
        os.environ["REPET_JOB_MANAGER"] = REPET_JOB_MANAGER_Initial_Value
        self.assertEquals(expClassName, obsClassName)

if __name__ == "__main__":
    unittest.main()