from copy import deepcopy
from commons.core.sql.TablePathAdaptator import TablePathAdaptator
from commons.core.coord.PathUtils import PathUtils
from commons.core.coord.Map import Map
from commons.core.coord.Path import Path
import os

class ConvPathChr2Chunk(object):

    def __init__(self, db, table, chunk_table, outtable):
        self._tablename = table
        self._chunk_table = chunk_table
        self._db = db
        self._outtable = outtable
        
    def convert(self):
        """
        Convert a 'path' table format.
        """
        temp_file = str(os.getpid()) + ".on_chunk"
        fout = open(temp_file,'w')

        str_mask = "SELECT * FROM "+\
            self._chunk_table + " WHERE chr='%s' AND ("+\
            "(%d BETWEEN LEAST(start,end) AND GREATEST(start,end))"+\
            " OR (%d BETWEEN LEAST(start,end) AND GREATEST(start,end))"+\
            " OR (%d <= LEAST(start,end) AND %d >= GREATEST(start,end)));"
                            
        iTPA = TablePathAdaptator(self._db, self._tablename)
        path_num_list = iTPA.getIdList()

        for path_num in path_num_list:        
            slist = iTPA.getPathListFromId(path_num)  
            for r in slist:
                r_min, r_max = PathUtils.getQueryMinMaxFromPathList([r])   
                sql_cmd = str_mask%(r.range_query.seqname,r_min,r_max,r_min,r_max)
                self._db.execute(sql_cmd)
                res = self._db.fetchall()
                for i in res:
                    chunk = Map(i[0],i[1],int(i[2]),int(i[3]))
                
                    new_r = Path()
                    new_r = deepcopy(r)
                    new_r.range_query.seqname = chunk.name
 
                    if (r.range_query.start > chunk.start and r.range_query.start < chunk.end):
                        new_r.range_query.start = r.range_query.start - chunk.start + 1 
                    if (r.range_query.end > chunk.start and r.range_query.end < chunk.end):
                        new_r.range_query.end = r.range_query.end - chunk.start + 1
                                                   
                    if r.range_query.isOnDirectStrand():
                        if r.range_query.start <= chunk.start:
                            new_r.range_query.start = 1
                        if r.range_query.end >= chunk.end:
                            new_r.range_query.end = chunk.end - chunk.start + 1
                    else:
                        if r.range_query.end <= chunk.start:
                            new_r.range_query.end = 1
                        if r.range_query.start >= chunk.end:
                            new_r.range_query.start = chunk.end - chunk.start + 1
                            
                    new_r.write(fout)
 
        fout.close()
    
        self._db.createTable(self._outtable, "path", temp_file)
    
        os.remove(temp_file)           