from commons.core.sql.DbFactory import DbFactory
from commons.core.utils.FileUtils import FileUtils
from commons.pyRepetUnit.convCoord.ConvMapChr2Chunk import ConvMapChr2Chunk
import unittest
import os

class Test_ConvMapChr2Chunk(unittest.TestCase):

    def setUp(self):
        self._mapfilename="dummy.map"
        self._maptablename="dummy_map"
        
        self._chunkmapfilename="chunk.map"
        self._chunkmaptable="test_chunk_map"
        
        self._resfilename="dummy_res.map"
        
        map4convData="chunk1\tchr1\t1\t100\n"
        map4convData+="chunk2\tchr1\t90\t200\n"
        map4convData+="chunk3\tchr1\t190\t300\n"

        map4conv=open(self._chunkmapfilename,"w")
        map4conv.write(map4convData)
        map4conv.close()
        
        self._db = DbFactory.createInstance()
        self._db.createTable(self._chunkmaptable, "map", self._chunkmapfilename, True)
        
        map2convData="reg1\tchr1\t10\t80\n"
        map2convData+="reg1\tchr1\t90\t110\n"
        map2convData+="reg2\tchr1\t150\t160\n"
        
        map2convData+="reg3\tchr1\t70\t210\n"
        map2convData+="reg4\tchr1\t85\t100\n"
        map2convData+="reg5\tchr1\t85\t110\n"
        
        map2convData+="reg6\tchr1\t80\t10\n"
        map2convData+="reg6\tchr1\t110\t90\n"
        map2convData+="reg7\tchr1\t160\t150\n"
        map2convData+="reg8\tchr1\t190\t300\n"
        
        map2convData+="reg9\tchr1\t210\t70\n"
        map2convData+="reg10\tchr1\t100\t85\n"
        map2convData+="reg11\tchr1\t110\t85\n"
        map2convData+="reg12\tchr1\t300\t190\n"
                        
        map2conv=open(self._mapfilename,"w")
        map2conv.write(map2convData)
        map2conv.close()
        
        self._db.createTable(self._maptablename, "map", self._mapfilename, True)

        mapResData="reg1\tchunk1\t10\t80\n"
        mapResData+="reg1\tchunk1\t90\t100\n"
        mapResData+="reg1\tchunk2\t1\t21\n"
        mapResData+="reg2\tchunk2\t61\t71\n"

        mapResData+="reg3\tchunk1\t70\t100\n"
        mapResData+="reg3\tchunk2\t1\t111\n"
        mapResData+="reg3\tchunk3\t1\t21\n"
        
        mapResData+="reg4\tchunk1\t85\t100\n"
        mapResData+="reg4\tchunk2\t1\t11\n"
        mapResData+="reg5\tchunk1\t85\t100\n"
        mapResData+="reg5\tchunk2\t1\t21\n"
        
        mapResData+="reg6\tchunk1\t80\t10\n"
        mapResData+="reg6\tchunk1\t100\t90\n"
        mapResData+="reg6\tchunk2\t21\t1\n"
        mapResData+="reg7\tchunk2\t71\t61\n"
        mapResData+="reg8\tchunk2\t101\t111\n"
        mapResData+="reg8\tchunk3\t1\t111\n"
        
        mapResData+="reg9\tchunk1\t100\t70\n"
        mapResData+="reg9\tchunk2\t111\t1\n"
        mapResData+="reg9\tchunk3\t21\t1\n"
        
        mapResData+="reg10\tchunk1\t100\t85\n"
        mapResData+="reg10\tchunk2\t11\t1\n"
        mapResData+="reg11\tchunk1\t100\t85\n"
        mapResData+="reg11\tchunk2\t21\t1\n"
        mapResData+="reg12\tchunk2\t111\t101\n"       
        mapResData+="reg12\tchunk3\t111\t1\n"       
                
        mapRes=open(self._resfilename,"w")
        mapRes.write(mapResData)
        mapRes.close()
        
    def tearDown(self):
        self._db.dropTable(self._chunkmaptable)
        self._db.dropTable(self._maptablename)
        self._db.close()
        os.remove(self._resfilename)
        os.remove(self._mapfilename)
        os.remove(self._chunkmapfilename)

    def test_convert(self):
        conv = ConvMapChr2Chunk(self._db,self._maptablename, self._chunkmaptable, self._maptablename+"_onchk")
        conv.convert()
        obsFileName = "dummy_map.onchk"
        self._db.exportDataToFile("dummy_map_onchk", obsFileName)
        self._db.dropTable("dummy_map_onchk")
        self.assertTrue(FileUtils.are2FilesIdentical(self._resfilename, obsFileName))
        os.remove(obsFileName)
        
test_suite = unittest.TestSuite()
test_suite.addTest( unittest.makeSuite( Test_ConvMapChr2Chunk ) )
if __name__ == '__main__':
    unittest.TextTestRunner(verbosity=2).run( test_suite )